/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.components.card;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record RecipeContentsData(NonNullList<ItemStack> recipeItems, ItemStack resultItem) {
    public static final RecipeContentsData EMPTY = new RecipeContentsData((NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY), ItemStack.EMPTY);
    public static final Codec<RecipeContentsData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ItemStack.OPTIONAL_CODEC.listOf().fieldOf("recipeItems").flatXmap(array -> {
        Object[] stacks = (ItemStack[])array.toArray(ItemStack[]::new);
        return stacks.length != 9 ? DataResult.error(() -> "More than 9 items for stored recipe") : DataResult.success((Object)NonNullList.of((Object)ItemStack.EMPTY, (Object[])stacks));
    }, DataResult::success).forGetter(recipe -> recipe.recipeItems), (App)ItemStack.STRICT_CODEC.fieldOf("resultItem").forGetter(RecipeContentsData::resultItem)).apply((Applicative)inst, RecipeContentsData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecipeContentsData> STREAM_CODEC = StreamCodec.of(RecipeContentsData::toNetwork, RecipeContentsData::fromNetwork);

    public RecipeContentsData {
        if (recipeItems.size() != 9) {
            throw new IllegalArgumentException("Recipe items must be 9 items long");
        }
    }

    private static RecipeContentsData fromNetwork(RegistryFriendlyByteBuf byteBuf) {
        NonNullList recipeItems = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 9; ++i) {
            recipeItems.set(i, (Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)byteBuf)));
        }
        ItemStack resultItem = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)byteBuf);
        return new RecipeContentsData((NonNullList<ItemStack>)recipeItems, resultItem);
    }

    private static void toNetwork(RegistryFriendlyByteBuf byteBuf, RecipeContentsData playerCompassData) {
        for (int i = 0; i < 9; ++i) {
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)byteBuf, (Object)((ItemStack)playerCompassData.recipeItems.get(i)));
        }
        ItemStack.STREAM_CODEC.encode((Object)byteBuf, (Object)playerCompassData.resultItem);
    }
}

