/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.compat.rei;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.compat.rei.infuser.category.InfuserCategory;
import com.mrbysco.forcecraft.compat.rei.infuser.display.InfuserDisplay;
import com.mrbysco.forcecraft.compat.rei.multipleoutput.category.FreezingCategory;
import com.mrbysco.forcecraft.compat.rei.multipleoutput.category.GrindingCategory;
import com.mrbysco.forcecraft.compat.rei.multipleoutput.display.FreezingDisplay;
import com.mrbysco.forcecraft.compat.rei.multipleoutput.display.GrindingDisplay;
import com.mrbysco.forcecraft.recipe.FreezingRecipe;
import com.mrbysco.forcecraft.recipe.GrindingRecipe;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.List;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@REIPluginClient
public class REIPlugin
implements REIClientPlugin {
    public static final ResourceLocation RECIPE_MULTIPLES_JEI = Reference.modLoc("textures/gui/jei/multiples.png");
    public static final ResourceLocation RECIPE_INFUSER_JEI = Reference.modLoc("textures/gui/jei/infuser.png");
    public static final CategoryIdentifier<FreezingDisplay> FREEZING_CATEGORY = CategoryIdentifier.of((String)"forcecraft", (String)"freezing");
    public static final CategoryIdentifier<GrindingDisplay> GRINDING_CATEGORY = CategoryIdentifier.of((String)"forcecraft", (String)"grinding");
    public static final CategoryIdentifier<InfuserDisplay> INFUSER_CATEGORY = CategoryIdentifier.of((String)"forcecraft", (String)"infuser");

    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new FreezingCategory());
        registry.add((DisplayCategory)new GrindingCategory());
        registry.add((DisplayCategory)new InfuserCategory());
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.BLACK_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.BLUE_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.BROWN_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.CYAN_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.GRAY_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.GREEN_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.LIGHT_BLUE_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.LIGHT_GRAY_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.LIME_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.MAGENTA_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.ORANGE_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.PINK_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.PURPLE_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.RED_FORCE_FURNACE.get()))});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.WHITE_FORCE_FURNACE.get()))});
        registry.addWorkstations(FREEZING_CATEGORY, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.FREEZING_CORE.get()))});
        registry.addWorkstations(GRINDING_CATEGORY, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.GRINDING_CORE.get()))});
        registry.addWorkstations(INFUSER_CATEGORY, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)ForceRegistry.INFUSER.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        List freezingHolders = registry.getRecipeManager().getAllRecipesFor(ForceRecipes.FREEZING.get());
        freezingHolders.forEach(holder -> {
            FreezingRecipe recipe = (FreezingRecipe)holder.value();
            registry.add((Display)new FreezingDisplay((Ingredient)recipe.getIngredients().getFirst(), (List<ItemStack>)recipe.getRecipeOutputs()));
        });
        List grindingHolders = registry.getRecipeManager().getAllRecipesFor(ForceRecipes.GRINDING.get());
        grindingHolders.forEach(holder -> {
            GrindingRecipe recipe = (GrindingRecipe)holder.value();
            registry.add((Display)new GrindingDisplay((Ingredient)recipe.getIngredients().getFirst(), (List<ItemStack>)recipe.getRecipeOutputs()));
        });
        List infuserHolders = registry.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get());
        infuserHolders.forEach(holder -> {
            InfuseRecipe recipe = (InfuseRecipe)holder.value();
            registry.add((Display)new InfuserDisplay(recipe.getCenter(), recipe.getIngredient(), recipe.getModifier(), recipe.getTier(), recipe.getResultItem((HolderLookup.Provider)registryAccess), recipe.getTime()));
        });
    }
}

