/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookTier;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

public class ForceCommands {
    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder root = Commands.literal((String)"force");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(source -> source.hasPermission(2))).then(Commands.literal((String)"ishard").executes(this::execute))).then(Commands.literal((String)"ishard").then(Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0, (int)7)).executes(this::executeSpecific)));
        dispatcher.register(root);
    }

    private int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        UpgradeBookTier bookTier = UpgradeBookTier.FINAL;
        ItemStack book = new ItemStack((ItemLike)ForceRegistry.UPGRADE_TOME.get());
        UpgradeBookData.setTier(book, bookTier);
        player.addItem(book);
        return 0;
    }

    private int executeSpecific(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        UpgradeBookTier bookTier = UpgradeBookTier.values()[tier];
        ItemStack book = new ItemStack((ItemLike)ForceRegistry.UPGRADE_TOME.get());
        UpgradeBookData.setTier(book, bookTier);
        player.addItem(book);
        return 0;
    }
}

