/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class RenderHelper {
    public static void drawFluidTankInGUI(FluidStack fluid, float x, float y, float percent, int height) {
        TextureAtlasSprite sprite;
        if (fluid == null || fluid.isEmpty()) {
            return;
        }
        ResourceLocation flowing = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid);
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
        if (texture instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).getSprite(flowing)) != null) {
            float minU = sprite.getU0();
            float maxU = sprite.getU1();
            float minV = sprite.getV0();
            float maxV = sprite.getV1();
            float deltaV = maxV - minV;
            double tankLevel = percent * (float)height;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            Color color = new Color(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid));
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
            RenderSystem.enableBlend();
            int count = 1 + (int)Math.ceil(tankLevel) / 16;
            for (int i = 0; i < count; ++i) {
                double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                double offsetY = (double)height - 16.0 * (double)i - subHeight;
                RenderHelper.drawQuad(x, (float)((double)y + offsetY), 16.0f, (float)subHeight, minU, (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static void drawQuad(float x, float y, float width, float height, float minU, float minV, float maxU, float maxV) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(x, y + height, 0.0f).setUv(minU, maxV);
        buffer.addVertex(x + width, y + height, 0.0f).setUv(maxU, maxV);
        buffer.addVertex(x + width, y, 0.0f).setUv(maxU, minV);
        buffer.addVertex(x, y, 0.0f).setUv(minU, minV);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static float getTankPercentage(int fluidAmount, int fluidMax) {
        return (float)fluidAmount / (float)fluidMax;
    }

    public static int getFluidGuiPercentage(int percentage, int maxHeight) {
        return (int)Math.ceil((float)percentage * (float)maxHeight);
    }
}

