/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.client.ClientHandler;
import com.mrbysco.forcecraft.client.model.EnderTotModel;
import com.mrbysco.forcecraft.client.renderer.layer.EnderTotHeldBlockLayer;
import com.mrbysco.forcecraft.client.renderer.layer.EndertotEyesLayer;
import com.mrbysco.forcecraft.entities.EnderTotEntity;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EnderTotRenderer
extends MobRenderer<EnderTotEntity, EnderTotModel<EnderTotEntity>> {
    private static final ResourceLocation ENDERTOT_TEXTURES = Reference.modLoc("textures/entity/ender_tot.png");
    private final Random rnd = new Random();

    public EnderTotRenderer(EntityRendererProvider.Context context) {
        super(context, new EnderTotModel(context.bakeLayer(ClientHandler.ENDERTOT)), 0.5f);
        this.addLayer((RenderLayer)new EndertotEyesLayer(this));
        this.addLayer(new EnderTotHeldBlockLayer((RenderLayerParent<EnderTotEntity, EnderTotModel<EnderTotEntity>>)this));
    }

    public void render(EnderTotEntity entityIn, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        BlockState blockstate = entityIn.getCarriedBlock();
        EnderTotModel endertotModel = (EnderTotModel)this.getModel();
        endertotModel.isCarrying = blockstate != null;
        endertotModel.isAttacking = entityIn.isCreepy();
        super.render((LivingEntity)entityIn, entityYaw, partialTicks, poseStack, bufferIn, packedLightIn);
    }

    public Vec3 getRenderOffset(EnderTotEntity entityIn, float partialTicks) {
        if (entityIn.isCreepy()) {
            double d0 = 0.02;
            return new Vec3(this.rnd.nextGaussian() * d0, 0.0, this.rnd.nextGaussian() * d0);
        }
        return super.getRenderOffset((Entity)entityIn, partialTicks);
    }

    public ResourceLocation getTextureLocation(EnderTotEntity entity) {
        return ENDERTOT_TEXTURES;
    }
}

