/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.model;

import com.mrbysco.forcecraft.entities.FairyEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class FairyModel<T extends FairyEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart inner;
    private final ModelPart leftWings;
    private final ModelPart rightWings;

    public FairyModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.root = root;
        this.inner = root.getChild("inner");
        this.leftWings = this.inner.getChild("left_wings");
        this.rightWings = this.inner.getChild("right_wings");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition inner = partdefinition.addOrReplaceChild("inner", CubeListBuilder.create().texOffs(0, 8).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition leftWings = inner.addOrReplaceChild("left_wings", CubeListBuilder.create().texOffs(16, 5).addBox(2.0f, -0.5f, 0.0f, 3.0f, 3.0f, 0.0f), PartPose.ZERO);
        leftWings.addOrReplaceChild("left_wings_top", CubeListBuilder.create().texOffs(16, 0).addBox(0.0f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)2.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightWings = inner.addOrReplaceChild("right_wings", CubeListBuilder.create().texOffs(22, 5).addBox(-5.0f, -0.5f, 0.0f, 3.0f, 3.0f, 0.0f), PartPose.ZERO);
        rightWings.addOrReplaceChild("right_wings_top", CubeListBuilder.create().texOffs(22, 0).addBox(-3.0f, -4.0f, 0.0f, 3.0f, 5.0f, 0.0f), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("outer", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean flag;
        this.leftWings.yRot = 0.0f;
        this.rightWings.yRot = 0.0f;
        boolean bl = flag = entityIn.onGround() && entityIn.getDeltaMovement().lengthSqr() < 1.0E-7;
        if (flag) {
            this.leftWings.yRot = -0.2618f;
            this.rightWings.yRot = 0.2618f;
        } else {
            float f = ageInTicks * 2.1f;
            this.rightWings.yRot = Mth.cos((float)f) * (float)Math.PI * 0.15f;
            this.leftWings.yRot = -this.rightWings.yRot;
        }
    }
}

