/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.client.model;

import com.mrbysco.forcecraft.entities.EnderTotEntity;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class EnderTotModel<T extends EnderTotEntity>
extends HumanoidModel<T> {
    public boolean isCarrying;
    public boolean isAttacking;

    public EnderTotModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)-14.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartPose partpose = PartPose.offset((float)0.0f, (float)-13.0f, (float)0.0f);
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), partpose);
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), partpose);
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 4.0f), PartPose.offset((float)0.0f, (float)-14.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)-5.0f, (float)-12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.offset((float)5.0f, (float)-12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(56, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.offset((float)-2.0f, (float)-5.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f), PartPose.offset((float)2.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.head.visible = true;
        float f = 8.0f;
        this.body.xRot = 0.0f;
        this.body.y = f;
        this.body.z = -0.0f;
        this.rightLeg.xRot -= 0.0f;
        this.leftLeg.xRot -= 0.0f;
        this.rightArm.xRot = (float)((double)this.rightArm.xRot * 0.5);
        this.leftArm.xRot = (float)((double)this.leftArm.xRot * 0.5);
        this.rightLeg.xRot = (float)((double)this.rightLeg.xRot * 0.5);
        this.leftLeg.xRot = (float)((double)this.leftLeg.xRot * 0.5);
        float f1 = 0.4f;
        if (this.rightArm.xRot > f1) {
            this.rightArm.xRot = f1;
        }
        if (this.leftArm.xRot > f1) {
            this.leftArm.xRot = f1;
        }
        if (this.rightArm.xRot < -f1) {
            this.rightArm.xRot = -f1;
        }
        if (this.leftArm.xRot < -f1) {
            this.leftArm.xRot = -f1;
        }
        if (this.rightLeg.xRot > f1) {
            this.rightLeg.xRot = f1;
        }
        if (this.leftLeg.xRot > f1) {
            this.leftLeg.xRot = f1;
        }
        if (this.rightLeg.xRot < -f1) {
            this.rightLeg.xRot = -f1;
        }
        if (this.leftLeg.xRot < -f1) {
            this.leftLeg.xRot = -f1;
        }
        if (this.isCarrying) {
            this.rightArm.xRot = -0.5f;
            this.leftArm.xRot = -0.5f;
            this.rightArm.zRot = 0.05f;
            this.leftArm.zRot = -0.05f;
        }
        this.rightArm.z = 0.0f;
        this.leftArm.z = 0.0f;
        this.rightLeg.z = 0.0f;
        this.leftLeg.z = 0.0f;
        this.rightLeg.y = 16.0f;
        this.leftLeg.y = 16.0f;
        this.head.z = -0.0f;
        this.head.y = f;
        this.hat.x = this.head.x;
        this.hat.y = 8.5f;
        this.hat.z = this.head.z;
        this.hat.xRot = this.head.xRot;
        this.hat.yRot = this.head.yRot;
        this.hat.zRot = this.head.zRot;
        if (this.isAttacking) {
            this.head.y -= 5.0f;
        }
        this.rightArm.setPos(-5.0f, 9.0f, 0.0f);
        this.leftArm.setPos(5.0f, 9.0f, 0.0f);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

