/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks.infuser;

import com.mojang.serialization.MapCodec;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class InfuserBlock
extends BaseEntityBlock {
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)5.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)4.0), Block.box((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)5.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)5.0, (double)14.0), Block.box((double)2.0, (double)5.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final MapCodec<InfuserBlock> CODEC = InfuserBlock.simpleCodec(InfuserBlock::new);

    public InfuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InfuserBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return InfuserBlock.createInfuserTicker(level, blockEntityType, ForceRegistry.INFUSER_BLOCK_ENTITY.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createInfuserTicker(Level level, BlockEntityType<T> p_151989_, BlockEntityType<? extends InfuserBlockEntity> infuserBlockEntityType) {
        return level.isClientSide ? null : InfuserBlock.createTickerHelper(p_151989_, infuserBlockEntityType, InfuserBlockEntity::serverTick);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof InfuserBlockEntity) {
            InfuserBlockEntity infuserBE = (InfuserBlockEntity)blockentity;
            IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, (Object)hitResult.getDirection());
            if (handler != null) {
                if (player.getItemInHand(hand).getCapability(Capabilities.FluidHandler.ITEM) != null) {
                    FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hitResult.getDirection());
                } else if (!level.isClientSide) {
                    player.openMenu((MenuProvider)infuserBE, pos);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            InfuserBlockEntity infuserBlockEntity;
            ItemStackHandler handler;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof InfuserBlockEntity && (handler = (infuserBlockEntity = (InfuserBlockEntity)blockentity).getItemHandler(null)) != null) {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)handler.getStackInSlot(i));
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighbourBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (!level.isClientSide) {
            InfuserBlockEntity infuserBE;
            boolean flag = level.hasNeighborSignal(pos);
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (flag && blockentity instanceof InfuserBlockEntity && (infuserBE = (InfuserBlockEntity)blockentity).hasValidRecipe() && !infuserBE.canWork) {
                infuserBE.startWork();
                infuserBE.setChanged();
            }
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof InfuserBlockEntity) {
            InfuserBlockEntity infuserTile = (InfuserBlockEntity)blockentity;
            if (infuserTile.processTime > 0) {
                double d0 = (double)pos.getX() + 0.5;
                double d1 = (double)pos.getY() + 0.5;
                double d2 = (double)pos.getZ() + 0.5;
                Direction direction = Direction.UP;
                Direction.Axis direction$axis = direction.getAxis();
                for (int i = 0; i < 3; ++i) {
                    double d3 = 0.52;
                    double d4 = rand.nextDouble() * 0.6 - 0.3;
                    double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * d3 : d4;
                    double d6 = rand.nextDouble() * 6.0 / 16.0;
                    double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * d3 : d4;
                    level.addParticle((ParticleOptions)ParticleTypes.REVERSE_PORTAL, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

