/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mojang.serialization.Codec;
import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.InfuserBlockEntity;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.tools.ForceAxeItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import com.mrbysco.forcecraft.items.tools.ForceSwordItem;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public enum InfuserModifierType implements StringRepresentable
{
    SPEED,
    HEAT,
    FORCE,
    SILK,
    DAMAGE,
    FORTUNE,
    LIGHT,
    STURDY,
    LUMBERJACK,
    HEALING,
    ENDER,
    BLEEDING,
    BANE,
    WING,
    CAMO,
    RAINBOW,
    TIME,
    PACK1,
    PACK2,
    PACK3,
    PACK4,
    GRINDING,
    FREEZING,
    EXP,
    STORAGE,
    SIGHT,
    TREASURE,
    ITEM;

    public static final Codec<InfuserModifierType> CODEC;

    public boolean apply(ItemStack tool, ItemStack mod, UpgradeBookData bd, HolderLookup.Provider provider) {
        switch (this.ordinal()) {
            case 4: {
                return InfuserBlockEntity.addDamageModifier(tool, provider);
            }
            case 10: {
                return InfuserBlockEntity.addEnderModifier(tool);
            }
            case 2: {
                return InfuserBlockEntity.addForceModifier(tool, provider);
            }
            case 9: {
                return InfuserBlockEntity.addHealingModifier(tool);
            }
            case 1: {
                return InfuserBlockEntity.addHeatModifier(tool, provider);
            }
            case 6: {
                return InfuserBlockEntity.addLightModifier(tool);
            }
            case 5: {
                return InfuserBlockEntity.addLuckModifier(tool, provider);
            }
            case 8: {
                return InfuserBlockEntity.addLumberjackModifier(tool);
            }
            case 3: {
                return InfuserBlockEntity.addSilkTouchModifier(tool, provider);
            }
            case 0: {
                return InfuserBlockEntity.addSpeedModifier(tool, provider);
            }
            case 7: {
                return InfuserBlockEntity.addSturdyModifier(tool, provider);
            }
            case 14: {
                return InfuserBlockEntity.applyCamo(tool, mod);
            }
            case 12: {
                return InfuserBlockEntity.addBaneModifier(tool);
            }
            case 11: {
                return InfuserBlockEntity.addBleedingModifier(tool);
            }
            case 13: {
                return InfuserBlockEntity.addWingModifier(tool);
            }
            case 15: {
                return InfuserBlockEntity.addRainbowModifier(tool);
            }
            case 16: {
                break;
            }
            case 26: {
                return InfuserBlockEntity.addTreasureModifier(tool);
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return InfuserBlockEntity.upgradeBag(tool, bd);
            }
            case 27: {
                return true;
            }
            case 23: {
                break;
            }
            case 22: {
                return InfuserBlockEntity.addFreezingModifier(tool);
            }
            case 21: {
                break;
            }
            case 25: {
                break;
            }
        }
        ForceCraft.LOGGER.error("Error: No action for modifier {}", (Object)this);
        return false;
    }

    public int getLevelCap(ItemStack centerStack) {
        Item item = centerStack.getItem();
        switch (this.ordinal()) {
            case 4: {
                if (item instanceof ForceSwordItem || item instanceof ForceBowItem) {
                    return (Integer)ConfigHandler.COMMON.damageCap.get();
                }
                if (!(item instanceof ForceArmorItem)) break;
                return 1;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return 1;
            }
            case 2: {
                if (!(item instanceof ForceSwordItem) && !(item instanceof ForceAxeItem)) break;
                return (Integer)ConfigHandler.COMMON.forceCap.get();
            }
            case 9: {
                if (!(item instanceof ForceRodItem)) break;
                return (Integer)ConfigHandler.COMMON.healingCap.get();
            }
            case 5: {
                return (Integer)ConfigHandler.COMMON.luckCap.get();
            }
            case 0: {
                if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceAxeItem) {
                    return (Integer)ConfigHandler.COMMON.speedCap.get();
                }
                if (item instanceof ForceBowItem) {
                    return 1;
                }
                if (item instanceof ForceArmorItem) {
                    return 1;
                }
                if (!(item instanceof ForceRodItem)) break;
                return (Integer)ConfigHandler.COMMON.rodSpeedCap.get();
            }
            case 7: {
                if (item instanceof ForceSwordItem || item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceRodItem) {
                    return (Integer)ConfigHandler.COMMON.sturdyToolCap.get();
                }
                if (!(item instanceof ForceArmorItem)) break;
                return 1;
            }
            case 11: {
                if (!(item instanceof ForceSwordItem) && !(item instanceof ForceBowItem) && !(item instanceof ForceArmorItem)) break;
                return (Integer)ConfigHandler.COMMON.bleedCap.get();
            }
            case 16: {
                if (!((Boolean)ConfigHandler.COMMON.timeTorchEnabled.get()).booleanValue()) break;
                return 1;
            }
        }
        return 0;
    }

    public String getTooltip() {
        return "gui.forcecraft.infuser.tooltip." + this.name().toLowerCase();
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    static {
        CODEC = StringRepresentable.fromEnum(InfuserModifierType::values);
    }
}

