/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.ForceCraft;
import com.mrbysco.forcecraft.blockentities.InfuserModifierType;
import com.mrbysco.forcecraft.blockentities.energy.ForceEnergyStorage;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.components.storage.PackStackHandler;
import com.mrbysco.forcecraft.components.storage.StorageManager;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.ForcePackItem;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import com.mrbysco.forcecraft.items.infuser.UpgradeBookData;
import com.mrbysco.forcecraft.items.infuser.UpgradeTomeItem;
import com.mrbysco.forcecraft.items.tools.ForceAxeItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShearsItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import com.mrbysco.forcecraft.items.tools.ForceSwordItem;
import com.mrbysco.forcecraft.menu.infuser.InfuserMenu;
import com.mrbysco.forcecraft.networking.message.StopInfuserSoundPayload;
import com.mrbysco.forcecraft.recipe.InfuseRecipe;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.registry.ForceTags;
import com.mrbysco.forcecraft.util.EnchantUtils;
import com.mrbysco.forcecraft.util.ItemHandlerUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfuserBlockEntity
extends BlockEntity
implements MenuProvider,
Container {
    private static final Set<String> HASHES = new HashSet<String>();
    public static final Map<Integer, List<ResourceLocation>> LEVEL_RECIPE_LIST = new HashMap<Integer, List<ResourceLocation>>();
    private static final int FLUID_CHARGE = 1000;
    public boolean canWork = false;
    public boolean makesSpecialSound = false;
    public int processTime = 0;
    public int maxProcessTime = 20;
    public static final int SLOT_TOOL = 8;
    public static final int SLOT_GEM = 9;
    public static final int SLOT_BOOK = 10;
    public static final int ENERGY_COST_PER = 20;
    public static final int FLUID_COST_PER = 1000;
    private static final int FLUID_PER_GEM = 500;
    protected FluidTank tank = new FluidTank(50000){

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!InfuserBlockEntity.this.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            if (action.simulate()) {
                int amount = InfuserBlockEntity.this.tank.getFluidAmount() - resource.getAmount() < 0 ? InfuserBlockEntity.this.tank.getFluidAmount() : resource.getAmount();
                return new FluidStack(InfuserBlockEntity.this.tank.getFluid().getFluid(), amount);
            }
            return super.drain(resource.getAmount(), action);
        }

        protected void onContentsChanged() {
            InfuserBlockEntity.this.refreshClient();
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            return super.drain(maxDrain, action);
        }

        public boolean isFluidValid(FluidStack stack) {
            return stack.is(ForceTags.FORCE);
        }
    };
    public final ItemStackHandler handler = new ItemStackHandler(11){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 9) {
                return 64;
            }
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot < 8) {
                return InfuserBlockEntity.this.matchesModifier(stack);
            }
            if (slot == 8) {
                return InfuserBlockEntity.this.matchesTool(stack);
            }
            if (slot == 10) {
                return stack.getItem() == ForceRegistry.UPGRADE_TOME.get();
            }
            if (slot == 9) {
                return stack.getItem() == ForceRegistry.FORCE_GEM.get();
            }
            return true;
        }
    };
    public ForceEnergyStorage energyStorage = new ForceEnergyStorage(64000, 1000);
    private final NonNullList<ItemStack> infuserContents = NonNullList.create();
    private Int2ObjectOpenHashMap<RecipeHolder<InfuseRecipe>> currentRecipes = new Int2ObjectOpenHashMap();

    public InfuserBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public InfuserBlockEntity(BlockPos pos, BlockState state) {
        this(ForceRegistry.INFUSER_BLOCK_ENTITY.get(), pos, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.processTime = compound.getInt("processTime");
        this.maxProcessTime = compound.getInt("maxProcessTime");
        this.canWork = compound.getBoolean("canWork");
        this.handler.deserializeNBT(registries, compound.getCompound("ItemStackHandler"));
        ContainerHelper.loadAllItems((CompoundTag)compound, this.infuserContents, (HolderLookup.Provider)registries);
        this.energyStorage.setEnergy(compound.getInt("EnergyHandler"));
        this.tank.readFromNBT(registries, compound);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("processTime", this.processTime);
        compound.putInt("maxProcessTime", this.maxProcessTime);
        compound.putBoolean("canWork", this.canWork);
        compound.put("ItemStackHandler", (Tag)this.handler.serializeNBT(registries));
        compound.putInt("EnergyHandler", this.energyStorage.getEnergyStored());
        ContainerHelper.saveAllItems((CompoundTag)compound, this.infuserContents, (HolderLookup.Provider)registries);
        this.tank.writeToNBT(registries, compound);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InfuserBlockEntity infuser) {
        if (level.getGameTime() % 20L == 0L && LEVEL_RECIPE_LIST.isEmpty()) {
            List holders = level.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get());
            for (RecipeHolder holder : holders) {
                InfuserBlockEntity.addRecipe((RecipeHolder<InfuseRecipe>)holder);
            }
        }
        if (infuser.handler.getStackInSlot(9).getItem() == ForceRegistry.FORCE_GEM.get()) {
            infuser.processForceGems();
        }
        if (infuser.canWork) {
            ++infuser.processTime;
            if (level.getGameTime() % 60L == 0L) {
                infuser.makeWorkSound();
            }
            if (infuser.energyStorage.getEnergyStored() > 20) {
                infuser.energyStorage.consumePower(20);
            }
            if (infuser.processTime < infuser.maxProcessTime) {
                return;
            }
            infuser.processTime = 0;
            if (infuser.isWorkAllowed()) {
                if (infuser.areAllModifiersEmpty() && infuser.canCharge()) {
                    infuser.processForceCharging();
                } else if (infuser.recipesStillMatch()) {
                    infuser.processTool();
                }
                infuser.stopWorkSound();
                if (infuser.makesSpecialSound) {
                    infuser.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL_DONE.get(), 1.0f, 1.0f);
                } else {
                    infuser.playSound((SoundEvent)ForceSounds.INFUSER_DONE.get(), 1.0f, 1.0f);
                }
                infuser.makesSpecialSound = false;
            }
            infuser.canWork = false;
            infuser.processTime = 0;
            infuser.refreshClient();
        } else {
            infuser.processTime = 0;
        }
    }

    public void startWork() {
        this.canWork = true;
        this.processTime = 0;
        this.setMaxTimeFromRecipes();
        if (this.areAllModifiersEmpty() && this.canCharge()) {
            this.maxProcessTime = (Integer)ConfigHandler.COMMON.forceInfusingTime.get();
        }
        if (this.maxProcessTime <= 0) {
            this.canWork = false;
            this.maxProcessTime = 0;
        }
        if (this.canWork) {
            this.stopWorkSound();
            this.makesSpecialSound = false;
            if (this.level != null && this.level.random.nextInt(10) == 0) {
                this.makesSpecialSound = true;
                this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL_BEEP.get(), 1.0f, 1.0f);
            }
            this.makeWorkSound();
        }
        this.refreshClient();
    }

    public void makeWorkSound() {
        if (this.makesSpecialSound) {
            this.playSound((SoundEvent)ForceSounds.INFUSER_SPECIAL.get(), 1.0f, 1.0f);
        } else {
            this.playSound((SoundEvent)ForceSounds.INFUSER_WORKING.get(), 1.0f, 1.0f);
        }
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        BlockPos pos = this.getBlockPos();
        if (this.level != null) {
            this.level.playSound((Player)null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), event, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public void stopWorkSound() {
        if (this.level != null && !this.level.isClientSide) {
            BlockPos pos = this.getBlockPos();
            for (Player player : this.level.players()) {
                if (!(player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < 200.0)) continue;
                ((ServerPlayer)player).connection.send((CustomPacketPayload)new StopInfuserSoundPayload());
            }
        }
    }

    private void setMaxTimeFromRecipes() {
        ArrayList recipes;
        this.maxProcessTime = 0;
        if (!this.getBookInSlot().isEmpty() && !(recipes = new ArrayList(this.getMatchingRecipes().values())).isEmpty()) {
            for (RecipeHolder currentHolder : recipes) {
                this.maxProcessTime += ((InfuseRecipe)currentHolder.value()).getTime();
            }
        }
    }

    protected Int2ObjectOpenHashMap<RecipeHolder<InfuseRecipe>> getMatchingRecipes() {
        if (this.getBookInSlot().isEmpty()) {
            return new Int2ObjectOpenHashMap();
        }
        if (!this.currentRecipes.isEmpty() && this.recipesStillMatch()) {
            return this.currentRecipes;
        }
        Int2ObjectOpenHashMap matchingRecipes = new Int2ObjectOpenHashMap();
        block0: for (int i = 0; i < 8; ++i) {
            ItemStack modifier = this.getModifier(i);
            if (modifier.isEmpty()) continue;
            List holders = this.level.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get());
            for (RecipeHolder holder : holders) {
                InfuseRecipe recipe = (InfuseRecipe)holder.value();
                if (!recipe.matchesModifier((RecipeInput)new RecipeWrapper((IItemHandler)this.handler), modifier, false)) continue;
                matchingRecipes.put(i, (Object)holder);
                continue block0;
            }
        }
        this.currentRecipes = matchingRecipes;
        return this.currentRecipes;
    }

    protected boolean matchesModifier(ItemStack stack) {
        if (this.level != null) {
            List holders = this.level.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get());
            for (RecipeHolder holder : holders) {
                InfuseRecipe recipe = (InfuseRecipe)holder.value();
                if (!recipe.matchesModifier(this, stack)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean matchesTool(ItemStack toolStack) {
        if (this.level != null) {
            List holders = this.level.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get());
            for (RecipeHolder holder : holders) {
                InfuseRecipe recipe = (InfuseRecipe)holder.value();
                if (!recipe.matchesTool(toolStack, true)) continue;
                return true;
            }
        }
        return toolStack.is(ForceTags.VALID_INFUSER_CHARGE);
    }

    protected boolean recipesStillMatch() {
        for (Map.Entry entry : this.currentRecipes.entrySet()) {
            ItemStack modifier = this.getModifier((Integer)entry.getKey());
            if (((InfuseRecipe)((RecipeHolder)entry.getValue()).value()).matchesModifier((RecipeInput)new RecipeWrapper((IItemHandler)this.handler), modifier, false)) continue;
            return false;
        }
        return true;
    }

    private void refreshClient() {
        this.setChanged();
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.sendBlockUpdated(this.worldPosition, state, state, 2);
    }

    private void processForceGems() {
        FluidStack force = new FluidStack((Fluid)ForceFluids.FORCE_FLUID_SOURCE.get(), 500);
        if (this.tank.getFluidAmount() + force.getAmount() <= this.tank.getCapacity()) {
            this.fill(force, IFluidHandler.FluidAction.EXECUTE);
            this.handler.getStackInSlot(9).shrink(1);
            this.refreshClient();
        }
    }

    public boolean areAllModifiersEmpty() {
        int emptySlots = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.handler.getStackInSlot(i).isEmpty()) continue;
            ++emptySlots;
        }
        return emptySlots == 8;
    }

    private void processForceCharging() {
        ItemStack tool = this.getFromToolSlot();
        ForceToolData force = new ForceToolData(tool);
        int charge = 1000;
        if (tool.isDamaged()) {
            int ratio = 25;
            int damage = tool.getDamageValue();
            int repaired = 0;
            for (int i = 0; i < damage; ++i) {
                if (charge < 25) continue;
                ++repaired;
                charge -= 25;
            }
            tool.setDamageValue(damage - repaired);
        }
        if (charge > 0) {
            force.charge(charge);
        }
        this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
    }

    private void processTool() {
        for (Map.Entry entry : this.currentRecipes.entrySet()) {
            ItemStack modifier = this.getModifier((Integer)entry.getKey());
            RecipeHolder recipeHolder = (RecipeHolder)entry.getValue();
            if (!((InfuseRecipe)recipeHolder.value()).matchesModifier((RecipeInput)new RecipeWrapper((IItemHandler)this.handler), modifier, true)) continue;
            ItemStack tool = this.getFromToolSlot();
            boolean success = this.applyModifier(tool, modifier, (RecipeHolder<InfuseRecipe>)recipeHolder);
            ForceCraft.LOGGER.debug("Applying modifier {} on tool {}, success: {}", (Object)modifier, (Object)tool, (Object)success);
            if (!success) continue;
            modifier.shrink(1);
            this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            UpgradeTomeItem.onModifierApplied(this.getBookInSlot(), modifier, tool);
        }
        this.level.sendBlockUpdated(this.worldPosition, this.level.getBlockState(this.worldPosition), this.level.getBlockState(this.worldPosition), 2);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, (HolderLookup.Provider)this.level.registryAccess());
        return tag;
    }

    public ItemStackHandler getItemHandler(@Nullable Direction facing) {
        return this.handler;
    }

    public FluidTank getFluidTank(@Nullable Direction facing) {
        return this.tank;
    }

    public ForceEnergyStorage getEnergyStorage(@Nullable Direction facing) {
        return this.energyStorage;
    }

    public boolean hasTool() {
        ItemStack tool = this.getFromToolSlot();
        return !tool.isEmpty();
    }

    public boolean hasValidBook() {
        ItemStack tool = this.getBookInSlot();
        if (!tool.isEmpty()) {
            return tool.getItem() == ForceRegistry.UPGRADE_TOME.get();
        }
        return false;
    }

    public ItemStack getFromToolSlot() {
        return this.handler.getStackInSlot(8);
    }

    public ItemStack getBookInSlot() {
        return this.handler.getStackInSlot(10);
    }

    public ItemStack getModifier(int slot) {
        if (slot >= 0 && slot <= 7) {
            return this.handler.getStackInSlot(slot);
        }
        return ItemStack.EMPTY;
    }

    public boolean hasValidModifer(int slot) {
        return !this.getModifier(slot).isEmpty();
    }

    public boolean canCharge() {
        ItemStack tool = this.getFromToolSlot();
        return this.isValidChargeableStack(tool) && this.tank.getFluidAmount() > 1000;
    }

    public boolean isValidChargeableStack(ItemStack stack) {
        return stack.is(ForceTags.VALID_INFUSER_CHARGE) && stack.has(ForceComponents.FORCE_INFUSED) && stack.getCount() == 1;
    }

    private boolean applyModifier(ItemStack tool, ItemStack modifier, RecipeHolder<InfuseRecipe> recipeHolder) {
        UpgradeBookData bd = (UpgradeBookData)this.getBookInSlot().getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)UpgradeBookData.DEFAULT);
        InfuseRecipe recipe = (InfuseRecipe)recipeHolder.value();
        if (recipe.getModifier().apply(tool, modifier, bd, (HolderLookup.Provider)this.level.registryAccess())) {
            bd.onRecipeApply(recipeHolder, this.getBookInSlot());
            if (recipe.getModifier() == InfuserModifierType.ITEM && recipe.hasOutput()) {
                this.handler.setStackInSlot(8, recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).copy());
            } else {
                this.handler.setStackInSlot(8, tool);
            }
            return true;
        }
        return false;
    }

    static boolean applyCamo(ItemStack tool, ItemStack mod) {
        PotionContents potionContents = (PotionContents)mod.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        for (MobEffectInstance e : potionContents.getAllEffects()) {
            if (e.getEffect() == MobEffects.NIGHT_VISION) {
                return InfuserBlockEntity.addSightModifier(tool);
            }
            if (e.getEffect() != MobEffects.INVISIBILITY) continue;
            return InfuserBlockEntity.addCamoModifier(tool);
        }
        return false;
    }

    static boolean addLightModifier(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ForceRodItem) {
            if (!stack.has(ForceComponents.ROD_LIGHT)) {
                stack.set(ForceComponents.ROD_LIGHT, (Object)true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem && !stack.has(ForceComponents.TOOL_LIGHT)) {
            stack.set(ForceComponents.TOOL_LIGHT, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    private static boolean addCamoModifier(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ForceRodItem) {
            if (!stack.has(ForceComponents.ROD_CAMO)) {
                stack.set(ForceComponents.ROD_CAMO, (Object)true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && !stack.has(ForceComponents.TOOL_CAMO)) {
            stack.set(ForceComponents.TOOL_CAMO, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    private static boolean addSightModifier(ItemStack stack) {
        if (stack.getItem() instanceof ForceRodItem && !stack.has(ForceComponents.ROD_SIGHT)) {
            stack.set(ForceComponents.ROD_SIGHT, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addWingModifier(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ForceSwordItem) {
            if (!stack.has(ForceComponents.TOOL_WING)) {
                stack.set(ForceComponents.TOOL_WING, (Object)true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && !stack.has(ForceComponents.TOOL_WING)) {
            stack.set(ForceComponents.TOOL_WING, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addBaneModifier(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ForceSwordItem) {
            if (!stack.has(ForceComponents.TOOL_BANE)) {
                stack.set(ForceComponents.TOOL_BANE, (Object)1);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            if (!stack.has(ForceComponents.TOOL_BANE)) {
                stack.set(ForceComponents.TOOL_BANE, (Object)1);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && !stack.has(ForceComponents.TOOL_BANE)) {
            stack.set(ForceComponents.TOOL_BANE, (Object)1);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addBleedingModifier(ItemStack stack) {
        int currentBleed;
        Item item = stack.getItem();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.bleedCap.get();
        if (item instanceof ForceSwordItem) {
            int currentBleed2 = (Integer)stack.getOrDefault(ForceComponents.TOOL_BLEED, (Object)0);
            if (currentBleed2 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_BLEED, (Object)(currentBleed2 + 1));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            int currentBleed3 = (Integer)stack.getOrDefault(ForceComponents.TOOL_BLEED, (Object)0);
            if (currentBleed3 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_BLEED, (Object)(currentBleed3 + 1));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (currentBleed = ((Integer)stack.getOrDefault(ForceComponents.TOOL_BLEED, (Object)0)).intValue()) < MAX_CAP) {
            stack.set(ForceComponents.TOOL_BLEED, (Object)(currentBleed + 1));
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addEnderModifier(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof ForceRodItem) {
            if (!stack.has(ForceComponents.ROD_ENDER)) {
                stack.set(ForceComponents.ROD_ENDER, (Object)true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem) {
            if (!stack.has(ForceComponents.TOOL_ENDER)) {
                stack.set(ForceComponents.TOOL_ENDER, (Object)true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem && !stack.has(ForceComponents.TOOL_ENDER)) {
            stack.set(ForceComponents.TOOL_ENDER, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addFreezingModifier(ItemStack stack) {
        if (stack.getItem() instanceof ForceBowItem && !stack.has(ForceComponents.TOOL_FREEZING)) {
            stack.set(ForceComponents.TOOL_FREEZING, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addHealingModifier(ItemStack stack) {
        if (stack.getItem() instanceof ForceRodItem) {
            int MAX_CAP = (Integer)ConfigHandler.COMMON.healingCap.get();
            int currentBleed = (Integer)stack.getOrDefault(ForceComponents.ROD_HEALING, (Object)0);
            if (currentBleed < MAX_CAP) {
                stack.set(ForceComponents.ROD_HEALING, (Object)(currentBleed + 1));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        }
        return false;
    }

    static boolean addLumberjackModifier(ItemStack stack) {
        if (stack.getItem() instanceof ForceAxeItem && !stack.has(ForceComponents.TOOL_LUMBERJACK)) {
            stack.set(ForceComponents.TOOL_LUMBERJACK, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addRainbowModifier(ItemStack stack) {
        if (stack.getItem() instanceof ForceShearsItem) {
            stack.set(ForceComponents.TOOL_RAINBOW, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addTreasureModifier(ItemStack stack) {
        if ((stack.getItem() instanceof ForceSwordItem || stack.getItem() instanceof ForceAxeItem) && !stack.has(ForceComponents.TOOL_TREASURE)) {
            stack.set(ForceComponents.TOOL_TREASURE, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean upgradeBag(ItemStack stack, UpgradeBookData bd) {
        if (stack.getItem() instanceof ForcePackItem) {
            PackStackHandler handler = StorageManager.getOrCreatePack(stack).getInventory();
            if (handler.canUpgrade(bd)) {
                handler.applyUpgrade();
                stack.set(ForceComponents.SLOTS_USED, (Object)ItemHandlerUtils.getUsedSlots((IItemHandler)handler));
                stack.set(ForceComponents.SLOTS_TOTAL, (Object)handler.getSlotsInUse());
                stack.set(ForceComponents.PACK_TIER, (Object)handler.getUpgrades());
                return true;
            }
            return false;
        }
        return false;
    }

    static boolean addSturdyModifier(ItemStack stack, HolderLookup.Provider provider) {
        int getSturdylevel;
        Item item = stack.getItem();
        if (item instanceof ForceSwordItem || item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceRodItem) {
            int getSturdylevel2 = (Integer)stack.getOrDefault(ForceComponents.TOOL_STURDY, (Object)0);
            if (getSturdylevel2 < (Integer)ConfigHandler.COMMON.sturdyToolCap.get()) {
                stack.set(ForceComponents.TOOL_STURDY, (Object)(getSturdylevel2 + 1));
                EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.UNBREAKING));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (getSturdylevel = ((Integer)stack.getOrDefault(ForceComponents.TOOL_STURDY, (Object)0)).intValue()) == 0) {
            stack.set(ForceComponents.TOOL_STURDY, (Object)(getSturdylevel + 1));
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addLuckModifier(ItemStack stack, HolderLookup.Provider provider) {
        int currentLuck;
        Item item = stack.getItem();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.luckCap.get();
        if (item instanceof ForcePickaxeItem || item instanceof ForceShovelItem || item instanceof ForceAxeItem) {
            int currentLuck2 = (Integer)stack.getOrDefault(ForceComponents.TOOL_LUCK, (Object)0);
            if (currentLuck2 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_LUCK, (Object)(currentLuck2 + 1));
                EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.FORTUNE));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem) {
            int currentLuck3 = (Integer)stack.getOrDefault(ForceComponents.TOOL_LUCK, (Object)0);
            if (currentLuck3 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_LUCK, (Object)(currentLuck3 + 1));
                EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.LOOTING));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            int currentLuck4 = (Integer)stack.getOrDefault(ForceComponents.TOOL_LUCK, (Object)0);
            if (currentLuck4 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_LUCK, (Object)(currentLuck4 + 1));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (currentLuck = ((Integer)stack.getOrDefault(ForceComponents.TOOL_LUCK, (Object)0)).intValue()) < MAX_CAP) {
            stack.set(ForceComponents.TOOL_LUCK, (Object)(currentLuck + 1));
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addDamageModifier(ItemStack stack, HolderLookup.Provider provider) {
        int currentSharpness;
        Item item = stack.getItem();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.damageCap.get();
        if (item instanceof ForceSwordItem) {
            int currentSharpness2 = (Integer)stack.getOrDefault(ForceComponents.TOOL_SHARPNESS, (Object)0);
            if (currentSharpness2 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_SHARPNESS, (Object)(currentSharpness2 + 1));
                EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.SHARPNESS));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            int currentSharpness3 = (Integer)stack.getOrDefault(ForceComponents.TOOL_SHARPNESS, (Object)0);
            if (currentSharpness3 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_SHARPNESS, (Object)(currentSharpness3 + 1));
                EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.POWER));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && (currentSharpness = ((Integer)stack.getOrDefault(ForceComponents.TOOL_SHARPNESS, (Object)0)).intValue()) < 1) {
            stack.set(ForceComponents.TOOL_SHARPNESS, (Object)(currentSharpness + 1));
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addSilkTouchModifier(ItemStack stack, HolderLookup.Provider provider) {
        Item item = stack.getItem();
        if ((item instanceof ForceAxeItem || item instanceof ForceShovelItem || item instanceof ForcePickaxeItem) && !stack.has(ForceComponents.TOOL_SILK)) {
            stack.set(ForceComponents.TOOL_SILK, (Object)true);
            stack.enchant(provider.holderOrThrow(Enchantments.SILK_TOUCH), 1);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addForceModifier(ItemStack stack, HolderLookup.Provider provider) {
        int currentForce;
        Item item = stack.getItem();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.forceCap.get();
        if ((item instanceof ForceSwordItem || item instanceof ForceAxeItem) && (currentForce = ((Integer)stack.getOrDefault(ForceComponents.TOOL_FORCE, (Object)0)).intValue()) < MAX_CAP) {
            stack.set(ForceComponents.TOOL_FORCE, (Object)(currentForce + 1));
            EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.KNOCKBACK));
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addHeatModifier(ItemStack stack, HolderLookup.Provider provider) {
        Item item = stack.getItem();
        if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceShearsItem) {
            if (!stack.has(ForceComponents.TOOL_HEAT)) {
                stack.set(ForceComponents.TOOL_HEAT, (Object)true);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceSwordItem || item instanceof ForceAxeItem) {
            if (!stack.has(ForceComponents.TOOL_HEAT)) {
                stack.set(ForceComponents.TOOL_HEAT, (Object)true);
                stack.enchant(provider.holderOrThrow(Enchantments.FIRE_ASPECT), 1);
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem && !stack.has(ForceComponents.TOOL_HEAT)) {
            stack.set(ForceComponents.TOOL_HEAT, (Object)true);
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static boolean addSpeedModifier(ItemStack stack, HolderLookup.Provider provider) {
        int currentSpeed;
        Item item = stack.getItem();
        int MAX_CAP = (Integer)ConfigHandler.COMMON.speedCap.get();
        if (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceAxeItem) {
            int currentSpeed2 = (Integer)stack.getOrDefault(ForceComponents.TOOL_SPEED, (Object)0);
            if (currentSpeed2 < MAX_CAP) {
                stack.set(ForceComponents.TOOL_SPEED, (Object)(currentSpeed2 + 1));
                EnchantUtils.incrementLevel(stack, (Holder<Enchantment>)provider.holderOrThrow(Enchantments.EFFICIENCY));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceBowItem) {
            int currentSpeed3 = (Integer)stack.getOrDefault(ForceComponents.TOOL_SPEED, (Object)0);
            if (currentSpeed3 < 1) {
                stack.set(ForceComponents.TOOL_SPEED, (Object)(currentSpeed3 + 1));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceArmorItem) {
            int currentSpeed4 = (Integer)stack.getOrDefault(ForceComponents.TOOL_SPEED, (Object)0);
            if (currentSpeed4 < 1) {
                stack.set(ForceComponents.TOOL_SPEED, (Object)(currentSpeed4 + 1));
                InfuserBlockEntity.addInfusedTag(stack);
                return true;
            }
        } else if (item instanceof ForceRodItem && (currentSpeed = ((Integer)stack.getOrDefault(ForceComponents.TOOL_SPEED, (Object)0)).intValue()) < (Integer)ConfigHandler.COMMON.rodSpeedCap.get()) {
            stack.set(ForceComponents.TOOL_SPEED, (Object)(currentSpeed + 1));
            InfuserBlockEntity.addInfusedTag(stack);
            return true;
        }
        return false;
    }

    static void addInfusedTag(ItemStack stack) {
        stack.set(ForceComponents.FORCE_INFUSED, (Object)true);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack resourceCopy = resource.copy();
        if (action.execute() && (this.tank.getFluid().isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tank.getFluid(), (FluidStack)resource))) {
            this.tank.fill(resourceCopy, action);
        }
        return resource.getAmount();
    }

    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public FluidStack getFluidStack() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid();
        }
        return null;
    }

    public boolean isWorkAllowed() {
        return this.hasTool() && this.hasValidBook();
    }

    public boolean hasValidRecipe() {
        return this.isWorkAllowed() && (this.areAllModifiersEmpty() && this.canCharge() || this.allSlotsMatchRecipe());
    }

    public boolean updateValidRecipe() {
        if (this.canWork) {
            this.canWork = false;
            this.processTime = 0;
            this.refreshClient();
        }
        return this.hasValidRecipe();
    }

    public boolean allSlotsMatchRecipe() {
        int requiredForce = 0;
        int requiredPower = 0;
        List holders = this.level.getRecipeManager().getAllRecipesFor(ForceRecipes.INFUSER_TYPE.get());
        boolean foundMatch = false;
        for (RecipeHolder holder : holders) {
            InfuseRecipe recipe = (InfuseRecipe)holder.value();
            ItemStack centerStack = this.getFromToolSlot();
            int amountFound = 0;
            for (int i = 0; i < 8; ++i) {
                ItemStack modifier = this.getModifier(i);
                if (modifier.isEmpty() || !recipe.matchesModifier((RecipeInput)new RecipeWrapper((IItemHandler)this.handler), modifier, false)) continue;
                foundMatch = true;
                ++amountFound;
                requiredForce += 1000;
                requiredPower += recipe.getTime() * 20;
            }
            if (amountFound <= 0 || amountFound <= recipe.getModifier().getLevelCap(centerStack)) continue;
            return false;
        }
        if (!foundMatch) {
            return false;
        }
        return this.getFluidAmount() >= requiredForce && this.getEnergy() >= requiredPower;
    }

    public int getBookTier() {
        if (!this.getBookInSlot().isEmpty()) {
            return ((UpgradeBookData)this.getBookInSlot().getOrDefault(ForceComponents.UPGRADE_BOOK, (Object)UpgradeBookData.DEFAULT)).tier().ordinal();
        }
        return 0;
    }

    public int getEnergyCostPer() {
        return 20;
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public void setFluidAmount(int amount) {
        if (amount > 0) {
            if (!this.tank.getFluid().isEmpty()) {
                this.tank.getFluid().setAmount(amount);
            }
        } else {
            this.tank.setFluid(FluidStack.EMPTY);
        }
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public void setEnergyStored(int energy) {
        this.energyStorage.setEnergy(energy);
    }

    public float getFluidPercentage() {
        return (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
    }

    protected boolean isFluidEqual(FluidStack fluid) {
        return this.isFluidEqual(fluid.getFluid());
    }

    protected boolean isFluidEqual(Fluid fluid) {
        return this.tank.getFluid().getFluid().equals(fluid);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"forcecraft.container.infuser");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
        return new InfuserMenu(id, playerInv, this);
    }

    public void clearContent() {
    }

    public ItemStack removeItem(int arg0, int arg1) {
        return ItemStack.EMPTY;
    }

    public int getContainerSize() {
        return 0;
    }

    public ItemStack getItem(int arg0) {
        return ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return !(player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) > 64.0);
    }

    public ItemStack removeItemNoUpdate(int arg0) {
        return ItemStack.EMPTY;
    }

    public void setItem(int arg0, ItemStack arg1) {
    }

    public static boolean addRecipe(RecipeHolder<InfuseRecipe> holder) {
        ResourceLocation id = holder.id();
        if (HASHES.contains(id.toString())) {
            return false;
        }
        InfuseRecipe recipe = (InfuseRecipe)holder.value();
        int thisTier = recipe.getTier().ordinal();
        if (!LEVEL_RECIPE_LIST.containsKey(thisTier)) {
            LEVEL_RECIPE_LIST.put(thisTier, new ArrayList());
        }
        LEVEL_RECIPE_LIST.get(thisTier).add(id);
        HASHES.add(id.toString());
        ForceCraft.LOGGER.info("Recipe loaded {} -> {} , {}", (Object)id.toString(), (Object)recipe.getModifier(), (Object)recipe.getIngredient());
        return true;
    }
}

