/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft;

import com.mrbysco.forcecraft.attachments.ForceAttachments;
import com.mrbysco.forcecraft.capability.CapabilityHandler;
import com.mrbysco.forcecraft.client.ClientHandler;
import com.mrbysco.forcecraft.client.KeybindHandler;
import com.mrbysco.forcecraft.command.ForceCommands;
import com.mrbysco.forcecraft.components.ForceComponents;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.handlers.BaneHandler;
import com.mrbysco.forcecraft.handlers.ForceDeathHandler;
import com.mrbysco.forcecraft.handlers.GrindstoneHandler;
import com.mrbysco.forcecraft.handlers.HeartHandler;
import com.mrbysco.forcecraft.handlers.LootTableHandler;
import com.mrbysco.forcecraft.handlers.LumberHandler;
import com.mrbysco.forcecraft.handlers.PlayerCapHandler;
import com.mrbysco.forcecraft.handlers.ToolModifierHandler;
import com.mrbysco.forcecraft.items.nonburnable.NonBurnableItemEntity;
import com.mrbysco.forcecraft.networking.PacketHandler;
import com.mrbysco.forcecraft.recipe.condition.ForceConditions;
import com.mrbysco.forcecraft.registry.ForceEffects;
import com.mrbysco.forcecraft.registry.ForceEntities;
import com.mrbysco.forcecraft.registry.ForceFluids;
import com.mrbysco.forcecraft.registry.ForceLootModifiers;
import com.mrbysco.forcecraft.registry.ForceMenus;
import com.mrbysco.forcecraft.registry.ForceModifiers;
import com.mrbysco.forcecraft.registry.ForceRecipeSerializers;
import com.mrbysco.forcecraft.registry.ForceRecipes;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import com.mrbysco.forcecraft.registry.ForceSounds;
import com.mrbysco.forcecraft.world.feature.ForceFeatures;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="forcecraft")
public class ForceCraft {
    public static final Logger LOGGER = LogManager.getLogger((String)"forcecraft");

    public ForceCraft(IEventBus eventBus, ModContainer container, Dist dist) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.commonSpec);
        eventBus.register(ConfigHandler.class);
        eventBus.addListener(CapabilityHandler::registerCapabilities);
        eventBus.addListener(PacketHandler::setupPackets);
        eventBus.addListener(this::setup);
        ForceFluids.registerFluids();
        ForceRegistry.BLOCKS.register(eventBus);
        ForceRegistry.BLOCK_ENTITY_TYPES.register(eventBus);
        ForceRegistry.ITEMS.register(eventBus);
        ForceRegistry.CREATIVE_MODE_TABS.register(eventBus);
        ForceSounds.SOUND_EVENTS.register(eventBus);
        ForceFluids.FLUID_TYPES.register(eventBus);
        ForceFluids.FLUIDS.register(eventBus);
        ForceEntities.ENTITY_TYPES.register(eventBus);
        ForceEffects.EFFECTS.register(eventBus);
        ForceFeatures.FEATURES.register(eventBus);
        ForceMenus.MENU_TYPES.register(eventBus);
        ForceLootModifiers.GLM.register(eventBus);
        ForceRecipes.RECIPE_TYPES.register(eventBus);
        ForceRecipeSerializers.RECIPE_SERIALIZERS.register(eventBus);
        ForceModifiers.BIOME_MODIFIER_SERIALIZERS.register(eventBus);
        ForceConditions.CONDITION_CODECS.register(eventBus);
        ForceComponents.COMPONENT_TYPE.register(eventBus);
        ForceAttachments.ATTACHMENT_TYPES.register(eventBus);
        NeoForge.EVENT_BUS.register((Object)new HeartHandler());
        NeoForge.EVENT_BUS.register((Object)new ForceDeathHandler());
        NeoForge.EVENT_BUS.register((Object)new ForceCommands());
        NeoForge.EVENT_BUS.register((Object)new BaneHandler());
        NeoForge.EVENT_BUS.register((Object)new PlayerCapHandler());
        NeoForge.EVENT_BUS.register((Object)new LootTableHandler());
        NeoForge.EVENT_BUS.register((Object)new ToolModifierHandler());
        NeoForge.EVENT_BUS.register((Object)new GrindstoneHandler());
        NeoForge.EVENT_BUS.register((Object)new LumberHandler());
        NeoForge.EVENT_BUS.addListener(NonBurnableItemEntity.EventHandler::onExpire);
        eventBus.addListener(ForceEntities::registerEntityAttributes);
        eventBus.addListener(ForceEntities::registerSpawnPlacement);
        NeoForgeMod.enableMilkFluid();
        if (dist.isClient()) {
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::onClientSetup);
            eventBus.addListener(ClientHandler::onRegisterMenu);
            eventBus.addListener(ClientHandler::registerKeymapping);
            eventBus.addListener(ClientHandler::registerEntityRenders);
            eventBus.addListener(ClientHandler::registerLayerDefinitions);
            eventBus.addListener(ClientHandler::registerItemColors);
            NeoForge.EVENT_BUS.addListener(KeybindHandler::onClientTick);
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> DispenserBlock.registerBehavior((ItemLike)((ItemLike)ForceRegistry.FORCE_SHEARS.get()), (DispenseItemBehavior)new ShearsDispenseItemBehavior()));
    }
}

