/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.ring_of_repair;

import com.kwpugh.ring_of_repair.Config;
import com.kwpugh.ring_of_repair.PlayerEquipsUtil;
import com.kwpugh.ring_of_repair.RingOfRepair;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class RepairTickHandler {
    static int minSlot = 0;
    static int maxSlot = 40;

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Level level = event.getEntity().level();
        Player entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Inventory inv2 = serverPlayer.getInventory();
            if (PlayerEquipsUtil.hasItemInInventory((Player)serverPlayer, (Item)RingOfRepair.RING_OF_REPAIR.get())) {
                if (serverPlayer.tickCount % Config.repairDelay == 0) {
                    RepairTickHandler.repair(serverPlayer, inv2);
                }
            } else if (Config.workInEnderchest && PlayerEquipsUtil.hasItemInEnderchest((Player)serverPlayer, (Item)RingOfRepair.RING_OF_REPAIR.get()) && serverPlayer.tickCount % Config.repairDelay == 0) {
                RepairTickHandler.repair(serverPlayer, inv2);
            }
        }
    }

    private static void repair(ServerPlayer serverPlayer, Inventory inv) {
        Level level = serverPlayer.level();
        if (level.isClientSide) {
            return;
        }
        switch (Config.repairMode) {
            case 0: {
                minSlot = 0;
                maxSlot = 40;
                break;
            }
            case 1: {
                minSlot = 0;
                maxSlot = 8;
                break;
            }
            case 2: {
                minSlot = 9;
                maxSlot = 35;
                break;
            }
            case 3: {
                minSlot = 36;
                maxSlot = 40;
                break;
            }
        }
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            ItemStack target = inv.getItem(slot);
            if (target.isEmpty() || target == serverPlayer.getMainHandItem() || !target.isDamaged() || !target.getItem().isRepairable(target)) continue;
            target.setDamageValue(target.getDamageValue() - 1);
            return;
        }
    }
}

