/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.transfer;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.api.recipe.GatedRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.RecipeHolder;

public class GatedRecipeTransferInfo<C extends AbstractContainerMenu, R extends GatedRecipe<?>>
implements IRecipeTransferInfo<C, RecipeHolder<R>> {
    public final Class<? extends C> containerClass;
    public final MenuType<C> menuType;
    public final RecipeType<RecipeHolder<R>> recipeType;
    public final int recipeSlotStart;
    public final int recipeSlotCount;
    public final int inventorySlotStart;
    public final int inventorySlotCount;

    public GatedRecipeTransferInfo(Class<? extends C> containerClass, MenuType<C> menuType, RecipeType<RecipeHolder<R>> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.containerClass = containerClass;
        this.menuType = menuType;
        this.recipeType = recipeType;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    public Class<? extends C> getContainerClass() {
        return this.containerClass;
    }

    public Optional<MenuType<C>> getMenuType() {
        return Optional.ofNullable(this.menuType);
    }

    public RecipeType<RecipeHolder<R>> getRecipeType() {
        return this.recipeType;
    }

    public boolean canHandle(C container, RecipeHolder<R> recipeHolder) {
        return this.isVisible(recipeHolder);
    }

    public List<Slot> getRecipeSlots(C container, RecipeHolder<R> recipeHolder) {
        ArrayList<Slot> slots = new ArrayList<Slot>(this.recipeSlotCount);
        for (int i = this.recipeSlotStart; i < this.recipeSlotStart + this.recipeSlotCount; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }

    public List<Slot> getInventorySlots(C container, RecipeHolder<R> recipeHolder) {
        ArrayList<Slot> slots = new ArrayList<Slot>(this.inventorySlotCount);
        for (int i = this.inventorySlotStart; i < this.inventorySlotStart + this.inventorySlotCount; ++i) {
            Slot slot = container.getSlot(i);
            slots.add(slot);
        }
        return slots;
    }

    public boolean isUnlocked(RecipeHolder<R> recipeHolder) {
        return this.hasAdvancement(((GatedRecipe)recipeHolder.value()).typeAdvancementID()) && this.hasAdvancement(((GatedRecipe)recipeHolder.value()).advancementID().orElse(null));
    }

    public boolean isVisible(RecipeHolder<R> recipeHolder) {
        return this.isUnlocked(recipeHolder) && !((GatedRecipe)recipeHolder.value()).isSecret();
    }

    public boolean hasAdvancement(ResourceLocation advancement) {
        return advancement == null || DatabankUtils.hasAdvancementClient((ResourceLocation)advancement);
    }
}

