/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.recipe.titration_barrel.TitrationBarrelRecipe;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import thelm.jeidrawables.JEIDrawables;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class TitrationBarrelRecipeCategory
extends AbstractGatedRecipeCategory<ITitrationBarrelRecipe> {
    public static final Component TITLE = Component.translatable((String)"block.pastel.titration_barrel");

    public TitrationBarrelRecipeCategory() {
        super(PastelJEI.TITRATION_BARREL, TITLE);
    }

    @Override
    public int getHeight() {
        return 49;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<ITitrationBarrelRecipe> recipeHolder, IFocusGroup focuses) {
        TitrationBarrelRecipe titrationBarrelRecipe;
        int startY;
        boolean visible = this.isVisible(recipeHolder);
        ITitrationBarrelRecipe recipe = (ITitrationBarrelRecipe)recipeHolder.value();
        List ingredients = recipe.getIngredientStacks();
        int inputCount = ingredients.size();
        boolean hasFluid = false;
        if (!recipe.getFluidInput().isEmpty()) {
            ++inputCount;
            hasFluid = true;
        }
        int startX = Math.max(11, 41 - inputCount * 10);
        int n = startY = inputCount > 3 ? 1 : 11;
        if (hasFluid) {
            this.addFluid(builder, RecipeIngredientRole.INPUT, startX, startY, recipe.getFluidInput(), this.fluidHelper().bucketVolume(), (IDrawable)JEIDrawables.SLOT, visible);
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            int x = startX + (hasFluid ? i + 1 : i) % 3 * 20;
            int y = startY + (hasFluid ? i + 1 : i) / 3 * 20;
            this.addItem(builder, RecipeIngredientRole.INPUT, x, y, ((IngredientStack)ingredients.get(i)).getItems().toList(), (IDrawable)JEIDrawables.SLOT, visible);
        }
        if (recipe.getTappingItem() != null && recipe.getTappingItem() != Items.AIR) {
            this.addItem(builder, RecipeIngredientRole.INPUT, 76, 21, new ItemStack((ItemLike)recipe.getTappingItem()), (IDrawable)JEIDrawables.SLOT, visible);
        }
        List<Object> outputVariations = recipe instanceof TitrationBarrelRecipe && (titrationBarrelRecipe = (TitrationBarrelRecipe)recipe).getFermentationData() != null ? List.copyOf(titrationBarrelRecipe.getOutputVariations(TitrationBarrelRecipe.FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS)) : List.of(recipe.getResultItem((HolderLookup.Provider)this.registryAccess()));
        this.addItem(builder, RecipeIngredientRole.OUTPUT, 105, 10, outputVariations, (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<ITitrationBarrelRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            ITitrationBarrelRecipe recipe = (ITitrationBarrelRecipe)recipeHolder.value();
            IDrawable recipeArrow = JEIDrawables.recipeArrow((int)(recipe.getMinFermentationTimeHours() * 1000));
            if (recipe.getTappingItem() == null || recipe.getTappingItem() == Items.AIR) {
                builder.addDrawable(recipeArrow, 73, 10);
            } else {
                builder.addDrawable(recipeArrow, 73, 2);
            }
        }
    }

    @Override
    public void draw(RecipeHolder<ITitrationBarrelRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            ITitrationBarrelRecipe recipe = (ITitrationBarrelRecipe)recipeHolder.value();
            Font font = this.font();
            MutableComponent durationComponent = TitrationBarrelRecipe.getDurationText((int)recipe.getMinFermentationTimeHours(), (FermentationData)recipe.getFermentationData());
            guiGraphics.drawString(font, (Component)durationComponent, this.getWidth() / 2 - font.width((FormattedText)durationComponent) / 2, 40, 0x3F3F3F, false);
        }
    }
}

