/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.fusion_shrine.FusionShrineRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.jeidrawables.JEIDrawables;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class FusionShrineRecipeCategory
extends AbstractGatedRecipeCategory<FusionShrineRecipe> {
    public static final Component TITLE = Component.translatable((String)"block.pastel.fusion_shrine");

    public FusionShrineRecipeCategory() {
        super(PastelJEI.FUSION_SHRINE, TITLE);
    }

    @Override
    public int getHeight() {
        return 79;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<FusionShrineRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        FusionShrineRecipe recipe = (FusionShrineRecipe)recipeHolder.value();
        if (!recipe.getFluid().isEmpty()) {
            this.addItem(builder, RecipeIngredientRole.CATALYST, 10, 26, PastelBlocks.FUSION_SHRINE_BASALT.toStack(), visible);
            this.addFluid(builder, RecipeIngredientRole.INPUT, 30, 26, recipe.getFluid(), this.fluidHelper().bucketVolume(), (IDrawable)JEIDrawables.SLOT, visible);
        } else {
            this.addItem(builder, RecipeIngredientRole.CATALYST, 20, 26, PastelBlocks.FUSION_SHRINE_BASALT.toStack(), visible);
        }
        List ingredients = recipe.getIngredientStacks();
        int startX = 1 + this.getWidth() / 2 - ingredients.size() * 9;
        for (int i = 0; i < ingredients.size(); ++i) {
            this.addItem(builder, RecipeIngredientRole.INPUT, startX + i * 18, 1, ((IngredientStack)ingredients.get(i)).getItems().toList(), (IDrawable)JEIDrawables.SLOT, visible);
        }
        this.addItem(builder, RecipeIngredientRole.OUTPUT, 94, 26, recipe.getResultItem((HolderLookup.Provider)this.registryAccess()), (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<FusionShrineRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            FusionShrineRecipe recipe = (FusionShrineRecipe)recipeHolder.value();
            builder.addDrawable(JEIDrawables.recipeArrow((int)(recipe.getCraftingTime() * 50)), 57, 26);
        }
    }

    @Override
    public void draw(RecipeHolder<FusionShrineRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            FusionShrineRecipe recipe = (FusionShrineRecipe)recipeHolder.value();
            Font font = this.font();
            if (recipe.getDescription().isPresent()) {
                List lines = font.split((FormattedText)recipe.getDescription().get(), 136);
                for (int i = 0; i < lines.size(); ++i) {
                    guiGraphics.drawString(font, (FormattedCharSequence)lines.get(i), 0, 49 + i * 10, 0x3F3F3F, false);
                }
            }
            Component timeComponent = this.getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
            guiGraphics.drawString(font, timeComponent, this.getWidth() / 2 - font.width((FormattedText)timeComponent) / 2, 70, 0x3F3F3F, false);
        }
    }
}

