/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.items.magic_items.KnowledgeGemItem;
import earth.terrarium.pastel.recipe.enchanter.EnchantmentUpgradeRecipe;
import earth.terrarium.pastel.registries.PastelAdvancements;
import earth.terrarium.pastel.registries.PastelBlocks;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import mezz.jei.api.gui.inputs.RecipeSlotUnderMouse;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ISlottedRecipeWidget;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class EnchantmentUpgradeRecipeCategory
extends AbstractGatedRecipeCategory<EnchantmentUpgradeRecipe> {
    public static final Component TITLE = Component.translatable((String)"container.pastel.rei.enchantment_upgrading.title");
    public static final Component TOOLTIP = Component.translatable((String)"container.pastel.rei.enchantment_upgrade.tooltip").withColor(14366052);
    public static final Component BUTTON = Component.translatable((String)"container.pastel.rei.enchantment_upgrade.button");
    public static final ResourceLocation BACKGROUND = PastelCommon.locate((String)"textures/gui/container/enchanter.png");
    public static final ResourceDrawable ALTAR = new ResourceDrawable(BACKGROUND, 0, 0, 54, 54);
    public static final ResourceDrawable OVERENCHANT = new ResourceDrawable(BACKGROUND, 64, 0, 16, 16);
    public static final ResourceDrawable MINUS = new ResourceDrawable(BACKGROUND, 64, 16, 8, 8);
    public static final ResourceDrawable PLUS = new ResourceDrawable(BACKGROUND, 72, 16, 8, 8);

    public EnchantmentUpgradeRecipeCategory() {
        super(PastelJEI.ENCHANTMENT_UPGRADE, TITLE);
    }

    @Override
    public int getHeight() {
        return 80;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EnchantmentUpgradeRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)recipeHolder.value();
        Item inputItem = recipe.getBulkItem();
        int inputCount = recipe.getBaseItemCost();
        this.addItem(builder, RecipeIngredientRole.INPUT, 113, 7, KnowledgeGemItem.getKnowledgeDropStackWithXP((int)recipe.getBaseXPCost(), (boolean)true), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.CATALYST, 113, 53, PastelBlocks.ENCHANTER.toStack(), visible);
        this.addSlot(builder, RecipeIngredientRole.INPUT, 34, 32, (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 21, 1, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 0)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 47, 1, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 1)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 65, 19, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 2)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 65, 45, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 3)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 47, 63, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 4)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 21, 63, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 5)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 3, 45, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 6)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addItem(builder, RecipeIngredientRole.INPUT, 3, 19, new ItemStack((ItemLike)inputItem, this.getSplitCount(inputCount, 7)), (IDrawable)JEIDrawables.SLOT, visible);
        this.addSlot(builder, RecipeIngredientRole.OUTPUT, 113, 32, (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(IntStream.range(1, recipe.getLevelCap()).mapToObj(this.levelToBook((Holder<Enchantment>)recipe.getEnchantment())).toList());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStacks(IntStream.rangeClosed(2, recipe.getLevelCap()).mapToObj(this.levelToBook((Holder<Enchantment>)recipe.getEnchantment())).toList());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<EnchantmentUpgradeRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)recipeHolder.value();
            builder.addDrawable((IDrawable)JEIDrawables.RECIPE_ARROW, 84, 32);
            builder.addDrawable((IDrawable)MINUS, 86, 20);
            builder.addDrawable((IDrawable)PLUS, 96, 20);
            List<IRecipeSlotDrawable> slots = List.copyOf(builder.getRecipeSlots().getSlots());
            int index = IntStream.concat(focuses.getItemStackFocuses(RecipeIngredientRole.INPUT).map(f -> (ItemStack)f.getTypedValue().getIngredient()).mapToInt(this.bookToLevel((Holder<Enchantment>)recipe.getEnchantment())), focuses.getItemStackFocuses(RecipeIngredientRole.OUTPUT).map(f -> (ItemStack)f.getTypedValue().getIngredient()).mapToInt(this.bookToLevel((Holder<Enchantment>)recipe.getEnchantment())).map(l -> l - 1)).filter(l -> l > 0).min().orElse(1);
            StateHandler stateHandler = new StateHandler(recipe, slots, index);
            builder.addSlottedWidget((ISlottedRecipeWidget)stateHandler, slots);
            builder.addGuiEventListener((IJeiGuiEventListener)new StateButton(this, new ScreenRectangle(86, 20, 8, 8), stateHandler, false));
            builder.addGuiEventListener((IJeiGuiEventListener)new StateButton(this, new ScreenRectangle(96, 20, 8, 8), stateHandler, true));
        }
    }

    @Override
    public void draw(RecipeHolder<EnchantmentUpgradeRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            ALTAR.draw(guiGraphics, 15, 13);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<EnchantmentUpgradeRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.isVisible(recipeHolder)) {
            EnchantmentUpgradeRecipe recipe = (EnchantmentUpgradeRecipe)recipeHolder.value();
            if (recipe.getLevelCap() > ((Enchantment)recipe.getEnchantment().value()).getMaxLevel() && this.hasAdvancement(PastelAdvancements.OVERENCHANTING) && mouseX >= 3.0 && mouseX < 19.0 && mouseY >= 1.0 && mouseY < 17.0) {
                tooltip.add((FormattedText)TOOLTIP);
            }
            if ((mouseX >= 86.0 && mouseX < 94.0 || mouseX >= 96.0 && mouseX < 104.0) && mouseY >= 20.0 && mouseY < 28.0) {
                tooltip.add((FormattedText)BUTTON);
            }
        }
    }

    public int getSplitCount(int inputCount, int index) {
        return inputCount / 8 + (index < inputCount % 8 ? 1 : 0);
    }

    public IntFunction<ItemStack> levelToBook(Holder<Enchantment> enchantment) {
        return level -> {
            ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            ItemEnchantments.Mutable itemEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            itemEnchantments.set(enchantment, level);
            book.set(DataComponents.STORED_ENCHANTMENTS, (Object)itemEnchantments.toImmutable());
            return book;
        };
    }

    public ToIntFunction<ItemStack> bookToLevel(Holder<Enchantment> enchantment) {
        return stack -> ((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).getLevel(enchantment);
    }

    public class StateHandler
    implements ISlottedRecipeWidget {
        static final ScreenPosition ZERO = new ScreenPosition(0, 0);
        final EnchantmentUpgradeRecipe recipe;
        final List<IRecipeSlotDrawable> slots;
        int index = 1;

        public StateHandler(EnchantmentUpgradeRecipe recipe, List<IRecipeSlotDrawable> slots, int index) {
            this.recipe = recipe;
            this.slots = slots;
            this.index = index;
            this.updateSlots();
        }

        public ScreenPosition getPosition() {
            return ZERO;
        }

        public boolean increase() {
            int cap = EnchantmentUpgradeRecipeCategory.this.hasAdvancement(PastelAdvancements.OVERENCHANTING) ? this.recipe.getLevelCap() : ((Enchantment)this.recipe.getEnchantment().value()).getMaxLevel();
            int newIndex = Math.clamp((long)(this.index + 1), 1, cap - 1);
            if (this.index == newIndex) {
                return false;
            }
            this.index = newIndex;
            this.updateSlots();
            return true;
        }

        public boolean decrease() {
            int cap = EnchantmentUpgradeRecipeCategory.this.hasAdvancement(PastelAdvancements.OVERENCHANTING) ? this.recipe.getLevelCap() : ((Enchantment)this.recipe.getEnchantment().value()).getMaxLevel();
            int newLevel = Math.clamp((long)(this.index - 1), 1, cap - 1);
            if (this.index == newLevel) {
                return false;
            }
            this.index = newLevel;
            this.updateSlots();
            return true;
        }

        public void updateSlots() {
            this.slots.forEach(IRecipeSlotDrawable::clearDisplayOverrides);
            this.slots.get(0).createDisplayOverrides().addItemStack(KnowledgeGemItem.getKnowledgeDropStackWithXP((int)this.recipe.getXpScaling().apply((double)this.index), (boolean)false));
            this.slots.get(2).createDisplayOverrides().addItemStack(EnchantmentUpgradeRecipeCategory.this.levelToBook((Holder<Enchantment>)this.recipe.getEnchantment()).apply(this.index));
            this.slots.get(11).createDisplayOverrides().addItemStack(EnchantmentUpgradeRecipeCategory.this.levelToBook((Holder<Enchantment>)this.recipe.getEnchantment()).apply(this.index + 1));
            Item inputItem = this.recipe.getBulkItem();
            int inputCount = this.recipe.getItemScaling().apply((double)this.index);
            for (int i = 0; i < 8; ++i) {
                this.slots.get(3 + i).createDisplayOverrides().addItemStack(new ItemStack((ItemLike)inputItem, EnchantmentUpgradeRecipeCategory.this.getSplitCount(inputCount, i)));
            }
        }

        public void drawWidget(GuiGraphics guiGraphics, double mouseX, double mouseY) {
            for (IRecipeSlotDrawable slot : this.slots) {
                slot.draw(guiGraphics);
            }
            if (EnchantmentUpgradeRecipeCategory.this.hasAdvancement(PastelAdvancements.OVERENCHANTING)) {
                OVERENCHANT.draw(guiGraphics, 3, 1);
            }
            Font font = EnchantmentUpgradeRecipeCategory.this.font();
            MutableComponent levelComponent = Component.translatable((String)"container.pastel.rei.enchantment_upgrade.level", (Object[])new Object[]{this.index, this.index + 1});
            MutableComponent reqComponent = Component.translatable((String)"container.pastel.rei.enchantment_upgrade.required_item_count", (Object[])new Object[]{this.recipe.getItemScaling().apply((double)this.index)});
            guiGraphics.drawString(font, (Component)levelComponent, 69, 2, this.index >= ((Enchantment)this.recipe.getEnchantment().value()).getMaxLevel() ? 14366052 : 0x3F3F3F, false);
            guiGraphics.drawString(font, (Component)reqComponent, 69, 71, 0x3F3F3F, false);
        }

        public Optional<RecipeSlotUnderMouse> getSlotUnderMouse(double mouseX, double mouseY) {
            for (IRecipeSlotDrawable slot : this.slots) {
                if (!slot.isMouseOver(mouseX, mouseY)) continue;
                return Optional.of(new RecipeSlotUnderMouse(slot, ZERO));
            }
            return Optional.empty();
        }
    }

    public class StateButton
    implements IJeiGuiEventListener {
        final ScreenRectangle area;
        final StateHandler handler;
        final boolean increase;

        public StateButton(EnchantmentUpgradeRecipeCategory this$0, ScreenRectangle area, StateHandler handler, boolean increase) {
            this.area = area;
            this.handler = handler;
            this.increase = increase;
        }

        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean clicked;
            boolean bl = clicked = this.increase ? this.handler.increase() : this.handler.decrease();
            if (clicked) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return clicked;
        }
    }
}

