/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.state.BlockBehaviour;
import thelm.jeidrawables.JEIDrawables;
import thelm.jeidrawables.gui.render.ResourceDrawable;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class CrystallarieumRecipeCategory
extends AbstractGatedRecipeCategory<CrystallarieumRecipe> {
    public static final Component TITLE = Component.translatable((String)"block.pastel.crystallarieum");
    public static final Component CATALYST = Component.translatable((String)"container.pastel.rei.crystallarieum.catalyst");
    public static final Component ACCELERATOR = Component.translatable((String)"container.pastel.rei.crystallarieum.accelerator");
    public static final Component INK_CONSUMPTION = Component.translatable((String)"container.pastel.rei.crystallarieum.ink_consumption");
    public static final Component USED_UP = Component.translatable((String)"container.pastel.rei.crystallarieum.used_up");
    public static final ResourceLocation BACKGROUND = PastelCommon.locate((String)"textures/gui/modonomicon/crystallarieum.png");
    public static final ResourceDrawable ACCEL_HIGHER = new ResourceDrawable(BACKGROUND, 98, 0, 7, 7, 128, 128);
    public static final ResourceDrawable ACCEL_HIGH = new ResourceDrawable(BACKGROUND, 91, 0, 7, 7, 128, 128);
    public static final ResourceDrawable ACCEL_NONE = new ResourceDrawable(BACKGROUND, 84, 0, 7, 7, 128, 128);
    public static final ResourceDrawable ACCEL_LOW = new ResourceDrawable(BACKGROUND, 77, 0, 7, 7, 128, 128);
    public static final ResourceDrawable ACCEL_LOWER = new ResourceDrawable(BACKGROUND, 70, 0, 7, 7, 128, 128);
    public static final ResourceDrawable CONSUME_HIGHER = new ResourceDrawable(BACKGROUND, 70, 7, 7, 7, 128, 128);
    public static final ResourceDrawable CONSUME_HIGH = new ResourceDrawable(BACKGROUND, 77, 7, 7, 7, 128, 128);
    public static final ResourceDrawable CONSUME_NORMAL = new ResourceDrawable(BACKGROUND, 84, 7, 7, 7, 128, 128);
    public static final ResourceDrawable CONSUME_LOW = new ResourceDrawable(BACKGROUND, 91, 7, 7, 7, 128, 128);
    public static final ResourceDrawable CONSUME_LOWER = new ResourceDrawable(BACKGROUND, 98, 7, 7, 7, 128, 128);
    public static final ResourceDrawable CHANCE_HIGHER = new ResourceDrawable(BACKGROUND, 70, 14, 7, 7, 128, 128);
    public static final ResourceDrawable CHANCE_HIGH = new ResourceDrawable(BACKGROUND, 77, 14, 7, 7, 128, 128);
    public static final ResourceDrawable CHANCE_NORMAL = new ResourceDrawable(BACKGROUND, 84, 14, 7, 7, 128, 128);
    public static final ResourceDrawable CHANCE_LOW = new ResourceDrawable(BACKGROUND, 91, 14, 7, 7, 128, 128);
    public static final ResourceDrawable CHANCE_NONE = new ResourceDrawable(BACKGROUND, 98, 14, 7, 7, 128, 128);

    public CrystallarieumRecipeCategory() {
        super(PastelJEI.CRYSTALLARIEUM, TITLE);
    }

    @Override
    public int getHeight() {
        return 99;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CrystallarieumRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        CrystallarieumRecipe recipe = (CrystallarieumRecipe)recipeHolder.value();
        this.addItem(builder, RecipeIngredientRole.INPUT, 7, 9, recipe.getIngredientStack(), (IDrawable)JEIDrawables.SLOT, visible);
        ItemStack stack = PastelBlocks.CRYSTALLARIEUM.toStack();
        stack.set(PastelDataComponentTypes.INK_COLOR, (Object)recipe.getInkColor());
        this.addItem(builder, RecipeIngredientRole.CATALYST, 27, 19, stack, visible);
        List<ItemStack> growthStages = recipe.getGrowthStages().stream().map(BlockBehaviour.BlockStateBase::getBlock).map(ItemStack::new).toList();
        this.addItem(builder, RecipeIngredientRole.INPUT, 27, 1, growthStages.get(0), (IDrawable)JEIDrawables.SLOT, visible);
        for (int i = 1; i < growthStages.size(); ++i) {
            this.addItem(builder, RecipeIngredientRole.OUTPUT, 53 + i * 20, 9, growthStages.get(i), (IDrawable)JEIDrawables.SLOT, visible);
        }
        List catalysts = recipe.getCatalysts();
        for (int i = 0; i < catalysts.size(); ++i) {
            int x = 53 + i * 18;
            this.addItem(builder, RecipeIngredientRole.CATALYST, x, 39, ((CrystallarieumCatalyst)catalysts.get(i)).ingredient(), (IDrawable)JEIDrawables.SLOT, visible);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<CrystallarieumRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            CrystallarieumRecipe recipe = (CrystallarieumRecipe)recipeHolder.value();
            builder.addDrawable(JEIDrawables.recipeArrow((int)(recipe.getSecondsPerGrowthStage() * 1000)), 47, 9);
            List catalysts = recipe.getCatalysts();
            for (int i = 0; i < catalysts.size(); ++i) {
                CrystallarieumCatalyst catalyst = (CrystallarieumCatalyst)catalysts.get(i);
                int x = 58 + i * 18;
                float growthAcceleration = catalyst.growthAccelerationMod();
                ResourceDrawable icon = growthAcceleration >= 5.0f ? ACCEL_HIGHER : (growthAcceleration > 1.0f ? ACCEL_HIGH : (growthAcceleration == 1.0f ? ACCEL_NONE : (growthAcceleration >= 0.2f ? ACCEL_LOW : ACCEL_LOWER)));
                builder.addDrawable((IDrawable)icon, x, 59);
                float inkConsumption = catalyst.inkConsumptionMod();
                icon = inkConsumption >= 5.0f ? CONSUME_HIGHER : (inkConsumption > 1.0f ? CONSUME_HIGH : (inkConsumption == 1.0f ? CONSUME_NORMAL : (inkConsumption >= 0.2f ? CONSUME_LOW : CONSUME_LOWER)));
                builder.addDrawable((IDrawable)icon, x, 69);
                float consumeChance = catalyst.consumeChancePerSecond();
                icon = consumeChance >= 0.25f ? CHANCE_HIGHER : (consumeChance >= 0.05f ? CHANCE_HIGH : (consumeChance >= 0.02f ? CHANCE_NORMAL : (consumeChance > 1.0E-4f ? CHANCE_LOW : CHANCE_NONE)));
                builder.addDrawable((IDrawable)icon, x, 79);
            }
        }
    }

    @Override
    public void draw(RecipeHolder<CrystallarieumRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            CrystallarieumRecipe recipe = (CrystallarieumRecipe)recipeHolder.value();
            Font font = this.font();
            MutableComponent timeComponent = recipe.growsWithoutCatalyst() ? Component.translatable((String)"container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds_catalyst_optional", (Object[])new Object[]{recipe.getSecondsPerGrowthStage()}) : Component.translatable((String)"container.pastel.rei.crystallarieum.crafting_time_per_stage_seconds", (Object[])new Object[]{recipe.getSecondsPerGrowthStage()});
            guiGraphics.drawString(font, CATALYST, 6, 43, 0x3F3F3F, false);
            guiGraphics.drawString(font, ACCELERATOR, 6, 58, 0x3F3F3F, false);
            guiGraphics.drawString(font, INK_CONSUMPTION, 6, 68, 0x3F3F3F, false);
            guiGraphics.drawString(font, USED_UP, 6, 78, 0x3F3F3F, false);
            guiGraphics.drawString(font, (Component)timeComponent, this.getWidth() / 2 - font.width((FormattedText)timeComponent) / 2, 90, 0x3F3F3F, false);
        }
    }
}

