/*
 * Decompiled with CFR 0.152.
 */
package thelm.pasteljei.recipe.category;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.cinderhearth.CinderhearthRecipe;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import thelm.jeidrawables.JEIDrawables;
import thelm.pasteljei.PastelJEI;
import thelm.pasteljei.recipe.category.AbstractGatedRecipeCategory;

public class CinderhearthRecipeCategory
extends AbstractGatedRecipeCategory<CinderhearthRecipe> {
    public static final Component TITLE = Component.translatable((String)"block.pastel.cinderhearth");
    public static final IDrawable FLAME = JEIDrawables.flame((int)10000);

    public CinderhearthRecipeCategory() {
        super(PastelJEI.CINDERHEARTH, TITLE);
    }

    @Override
    public int getHeight() {
        return 51;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CinderhearthRecipe> recipeHolder, IFocusGroup focuses) {
        boolean visible = this.isVisible(recipeHolder);
        CinderhearthRecipe recipe = (CinderhearthRecipe)recipeHolder.value();
        this.addItem(builder, RecipeIngredientRole.INPUT, 4, 1, ((IngredientStack)recipe.getIngredientStacks().get(0)).getItems().toList(), (IDrawable)JEIDrawables.SLOT, visible);
        List outputs = recipe.getResultsWithChance();
        for (int i = 0; i < 3; ++i) {
            IIngredientAcceptor<?> acceptor = this.addSlot(builder, RecipeIngredientRole.OUTPUT, 58 + i * 28, 10, (IDrawable)JEIDrawables.OUTPUT_SLOT, visible);
            if (i >= outputs.size()) continue;
            acceptor.addItemStack((ItemStack)((Tuple)outputs.get(i)).getA());
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<CinderhearthRecipe> recipeHolder, IFocusGroup focuses) {
        if (this.isVisible(recipeHolder)) {
            CinderhearthRecipe recipe = (CinderhearthRecipe)recipeHolder.value();
            builder.addDrawable(JEIDrawables.recipeArrow((int)(recipe.getCraftingTime() * 50)), 26, 10);
            builder.addDrawable(FLAME, 4, 19);
        }
    }

    @Override
    public void draw(RecipeHolder<CinderhearthRecipe> recipeHolder, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw(recipeHolder, recipeSlotsView, guiGraphics, mouseX, mouseY);
        if (this.isVisible(recipeHolder)) {
            CinderhearthRecipe recipe = (CinderhearthRecipe)recipeHolder.value();
            Font font = this.font();
            List outputs = recipe.getResultsWithChance();
            for (int i = 0; i < outputs.size(); ++i) {
                if (!(((Float)((Tuple)outputs.get(i)).getB()).floatValue() < 1.0f)) continue;
                MutableComponent chanceComponent = Component.literal((String)((int)(((Float)((Tuple)outputs.get(i)).getB()).floatValue() * 100.0f) + "%"));
                guiGraphics.drawString(font, (Component)chanceComponent, 67 + i * 28 - font.width((FormattedText)chanceComponent) / 2, 32, 0x3F3F3F, false);
            }
            Component timeComponent = this.getTimeComponent(recipe.getCraftingTime(), recipe.getExperience());
            guiGraphics.drawString(font, timeComponent, this.getWidth() / 2 - font.width((FormattedText)timeComponent) / 2, 42, 0x3F3F3F, false);
        }
    }
}

