/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.ClassifyCharacter;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.ArrayList;
import java.util.List;

public final class Attention {
    public static final Construct attention = new Construct();

    private Attention() {
    }

    private static List<Tokenizer.Event> resolveAllAttention(List<Tokenizer.Event> events, TokenizeContext context) {
        Tokenizer.Event event;
        int index = -1;
        block0: while (++index < events.size()) {
            event = events.get(index);
            if (event.type() != Tokenizer.EventType.ENTER || !event.token().type.equals("attentionSequence") || !event.token()._close) continue;
            int open = index;
            while (open-- > 0) {
                int offset;
                Tokenizer.Event openEvent = events.get(open);
                if (openEvent.type() != Tokenizer.EventType.EXIT || !openEvent.token().type.equals("attentionSequence") || !openEvent.token()._open || context.sliceSerialize(openEvent.token()).charAt(0) != context.sliceSerialize(event.token()).charAt(0) || (openEvent.token()._close || event.token()._open) && (event.token().end.offset() - event.token().start.offset()) % 3 != 0 && (openEvent.token().end.offset() - openEvent.token().start.offset() + event.token().end.offset() - event.token().start.offset()) % 3 == 0) continue;
                int use = openEvent.token().end.offset() - openEvent.token().start.offset() > 1 && event.token().end.offset() - event.token().start.offset() > 1 ? 2 : 1;
                Point start = openEvent.token().end;
                Point end = event.token().start;
                start = Attention.movePoint(start, -use);
                end = Attention.movePoint(end, use);
                Token openingSequence = new Token();
                openingSequence.type = use > 1 ? "strongSequence" : "emphasisSequence";
                openingSequence.start = start;
                openingSequence.end = openEvent.token().end;
                Token closingSequence = new Token();
                closingSequence.type = use > 1 ? "strongSequence" : "emphasisSequence";
                closingSequence.start = event.token().start;
                closingSequence.end = end;
                Token text = new Token();
                text.type = use > 1 ? "strongText" : "emphasisText";
                text.start = openEvent.token().end;
                text.end = event.token().start;
                Token group = new Token();
                group.type = use > 1 ? "strong" : "emphasis";
                group.start = openingSequence.start;
                group.end = closingSequence.end;
                openEvent.token().end = openingSequence.start;
                event.token().start = closingSequence.end;
                List<Object> nextEvents = new ArrayList();
                if (openEvent.token().end.offset() - openEvent.token().start.offset() != 0) {
                    nextEvents = ListUtils.push(nextEvents, List.of(Tokenizer.Event.enter(openEvent.token(), context), Tokenizer.Event.exit(openEvent.token(), context)));
                }
                nextEvents = ListUtils.push(nextEvents, List.of(Tokenizer.Event.enter(group, context), Tokenizer.Event.enter(openingSequence, context), Tokenizer.Event.exit(openingSequence, context), Tokenizer.Event.enter(text, context)));
                nextEvents = ListUtils.push(nextEvents, Construct.resolveAll(context.getParser().constructs.nullInsideSpan, ListUtils.slice(events, open + 1, index), context));
                nextEvents = ListUtils.push(nextEvents, List.of(Tokenizer.Event.exit(text, context), Tokenizer.Event.enter(closingSequence, context), Tokenizer.Event.exit(closingSequence, context), Tokenizer.Event.exit(group, context)));
                if (event.token().end.offset() - event.token().start.offset() != 0) {
                    offset = 2;
                    nextEvents = ListUtils.push(nextEvents, List.of(Tokenizer.Event.enter(event.token(), context), Tokenizer.Event.exit(event.token(), context)));
                } else {
                    offset = 0;
                }
                ListUtils.splice(events, open - 1, index - open + 3, nextEvents);
                index = open + nextEvents.size() - offset - 2;
                continue block0;
            }
        }
        index = -1;
        while (++index < events.size()) {
            event = events.get(index);
            if (!event.token().type.equals("attentionSequence")) continue;
            event.token().type = "data";
        }
        return events;
    }

    private static Point movePoint(Point point, int offset) {
        return new Point(point.line(), point.column() + offset, point.offset() + offset, point._index(), point._bufferIndex() + offset);
    }

    static {
        Attention.attention.name = "attention";
        Attention.attention.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok)::start;
        Attention.attention.resolveAll = Attention::resolveAllAttention;
    }

    static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final int previous;
        private final int before;
        private final List<Integer> attentionMarkers;
        int marker;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.attentionMarkers = context.getParser().constructs.nullAttentionMarkers;
            this.previous = context.getPrevious();
            this.before = ClassifyCharacter.classifyCharacter(this.previous);
        }

        State start(int code) {
            if (code != 42 && code != 95) {
                throw new IllegalStateException("expected asterisk or underscore");
            }
            this.effects.enter("attentionSequence");
            this.marker = code;
            return this.sequence(code);
        }

        State sequence(int code) {
            boolean close;
            if (code == this.marker) {
                this.effects.consume(code);
                return this::sequence;
            }
            Token token = this.effects.exit("attentionSequence");
            int after = ClassifyCharacter.classifyCharacter(code);
            boolean open = after == 0 || after == 2 && this.before != 0 || this.attentionMarkers.contains(code);
            boolean bl = close = this.before == 0 || this.before == 2 && after != 0 || this.attentionMarkers.contains(this.previous);
            boolean bl2 = this.marker == 42 ? open : (token._open = open && (this.before != 0 || !close));
            token._close = this.marker == 42 ? close : close && (after != 0 || !open);
            return this.ok.step(code);
        }
    }
}

