/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.AlreadyClosedException;
import guideme.internal.shaded.lucene.store.FSDirectory;
import guideme.internal.shaded.lucene.store.FSLockFactory;
import guideme.internal.shaded.lucene.store.Lock;
import guideme.internal.shaded.lucene.store.LockObtainFailedException;
import guideme.internal.shaded.lucene.store.LockReleaseFailedException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;

public final class SimpleFSLockFactory
extends FSLockFactory {
    public static final SimpleFSLockFactory INSTANCE = new SimpleFSLockFactory();

    private SimpleFSLockFactory() {
    }

    @Override
    protected Lock obtainFSLock(FSDirectory dir, String lockName) throws IOException {
        Path lockDir = dir.getDirectory();
        Files.createDirectories(lockDir, new FileAttribute[0]);
        Path lockFile = lockDir.resolve(lockName);
        try {
            Files.createFile(lockFile, new FileAttribute[0]);
        }
        catch (AccessDeniedException | FileAlreadyExistsException e) {
            throw new LockObtainFailedException("Lock held elsewhere: " + String.valueOf(lockFile), e);
        }
        FileTime creationTime = Files.readAttributes(lockFile, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        return new SimpleFSLock(lockFile, creationTime);
    }

    static final class SimpleFSLock
    extends Lock {
        private final Path path;
        private final FileTime creationTime;
        private volatile boolean closed;

        SimpleFSLock(Path path, FileTime creationTime) throws IOException {
            this.path = path;
            this.creationTime = creationTime;
        }

        @Override
        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new AlreadyClosedException("Lock instance already released: " + String.valueOf(this));
            }
            FileTime ctime = Files.readAttributes(this.path, BasicFileAttributes.class, new LinkOption[0]).creationTime();
            if (!this.creationTime.equals(ctime)) {
                throw new AlreadyClosedException("Underlying file changed by an external force at " + String.valueOf(ctime) + ", (lock=" + String.valueOf(this) + ")");
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                try {
                    this.ensureValid();
                }
                catch (Throwable exc) {
                    throw new LockReleaseFailedException("Lock file cannot be safely removed. Manual intervention is recommended.", exc);
                }
                try {
                    Files.delete(this.path);
                }
                catch (Throwable exc) {
                    throw new LockReleaseFailedException("Unable to remove lock file. Manual intervention is recommended", exc);
                }
            }
            finally {
                this.closed = true;
            }
        }

        public String toString() {
            return "SimpleFSLock(path=" + String.valueOf(this.path) + ",creationTime=" + String.valueOf(this.creationTime) + ")";
        }
    }
}

