/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class WallPatchFeatureConfig
implements FeatureConfiguration {
    public static final Codec<WallPatchFeatureConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").forGetter(config -> config.block), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(config -> config.searchRange), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(config -> config.placeOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(config -> config.placeOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(config -> config.placeOnWalls), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("width").forGetter(config -> config.width), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("height").forGetter(config -> config.height), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).fieldOf("can_be_placed_on").forGetter(config -> config.canPlaceOn)).apply((Applicative)instance, WallPatchFeatureConfig::new));
    public final Block block;
    public final int searchRange;
    public final boolean placeOnFloor;
    public final boolean placeOnCeiling;
    public final boolean placeOnWalls;
    public final IntProvider width;
    public final IntProvider height;
    public final HolderSet<Block> canPlaceOn;
    private final ObjectArrayList<Direction> directions;

    public WallPatchFeatureConfig(Block block, Integer searchRange, Boolean placeOnFloor, Boolean placeOnCeiling, Boolean placeOnWalls, IntProvider width, IntProvider height, HolderSet<Block> canPlaceOn) {
        this.block = block;
        this.searchRange = searchRange;
        this.placeOnFloor = placeOnFloor;
        this.placeOnCeiling = placeOnCeiling;
        this.placeOnWalls = placeOnWalls;
        this.width = width;
        this.height = height;
        this.canPlaceOn = canPlaceOn;
        this.directions = new ObjectArrayList(6);
        if (placeOnCeiling.booleanValue()) {
            this.directions.add((Object)Direction.UP);
        }
        if (placeOnFloor.booleanValue()) {
            this.directions.add((Object)Direction.DOWN);
        }
        if (placeOnWalls.booleanValue()) {
            Direction.Plane.HORIZONTAL.forEach(arg_0 -> this.directions.add(arg_0));
        }
    }

    public List<Direction> shuffleDirections(RandomSource random, Direction excluded) {
        return Util.toShuffledList(this.directions.stream().filter(direction -> direction != excluded), (RandomSource)random);
    }

    public List<Direction> shuffleDirections(RandomSource random) {
        return Util.shuffledCopy(this.directions, (RandomSource)random);
    }
}

