/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.worldgen.features;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.blocks.jade_vines.JadeiteLotusFlowerBlock;
import earth.terrarium.pastel.blocks.jade_vines.JadeiteLotusStemBlock;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.worldgen.features.JadeiteLotusFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class JadeiteLotusFeature
extends Feature<JadeiteLotusFeatureConfig> {
    public JadeiteLotusFeature(Codec<JadeiteLotusFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<JadeiteLotusFeatureConfig> context) {
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        ChunkGenerator chunkGen = context.chunkGenerator();
        Boolean inverted = ((JadeiteLotusFeatureConfig)context.config()).inverted();
        BlockState floorState = world.getBlockState(inverted != false ? origin.below() : origin.above());
        if (!floorState.is(BlockTags.DIRT) && !floorState.is(PastelBlockTags.BASE_STONE_DEEPER_DOWN)) {
            return false;
        }
        int stemHeight = Math.round(Mth.normal((RandomSource)random, (float)8.0f, (float)10.0f) + 5.0f);
        BlockPos.MutableBlockPos mutablePos = origin.mutable();
        for (int i = 0; i < stemHeight + 2; ++i) {
            if (inverted.booleanValue()) {
                mutablePos.move(Direction.UP);
                if (mutablePos.getY() <= chunkGen.getGenDepth() && JadeiteLotusFeature.isReplaceable((LevelAccessor)world, (BlockPos)mutablePos)) continue;
                stemHeight = i - 2 - random.nextInt(2);
                break;
            }
            mutablePos.move(Direction.DOWN);
            if (mutablePos.getY() >= chunkGen.getMinY() && JadeiteLotusFeature.isReplaceable((LevelAccessor)world, (BlockPos)mutablePos)) continue;
            stemHeight = i - 2 - random.nextInt(2);
            break;
        }
        if (stemHeight < 4) {
            return false;
        }
        this.generateStem((LevelAccessor)world, origin, stemHeight, inverted);
        return true;
    }

    private static boolean isReplaceable(LevelAccessor world, BlockPos pos) {
        return world.getBlockState(pos).canBeReplaced();
    }

    private void generateStem(LevelAccessor world, BlockPos origin, int stemHeight, boolean inverted) {
        BlockPos.MutableBlockPos stemPointer = origin.mutable();
        boolean topStem = false;
        for (int height = 0; height < stemHeight; ++height) {
            if (height == 0) {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, (BlockState)((Block)PastelBlocks.JADEITE_LOTUS_STEM.get()).defaultBlockState().setValue((Property)JadeiteLotusStemBlock.INVERTED, (Comparable)Boolean.valueOf(inverted)));
                topStem = true;
            } else if (height == stemHeight - 1) {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, (BlockState)((Block)PastelBlocks.JADEITE_LOTUS_FLOWER.get()).defaultBlockState().setValue((Property)JadeiteLotusFlowerBlock.FACING, (Comparable)(inverted ? Direction.UP : Direction.DOWN)));
            } else {
                this.setBlock((LevelWriter)world, (BlockPos)stemPointer, JadeiteLotusStemBlock.getStemVariant(topStem, inverted));
                topStem = !topStem;
            }
            stemPointer.move(0, inverted ? 1 : -1, 0);
        }
    }
}

