/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.status_effects;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class NourishingStatusEffect
extends MobEffect {
    public NourishingStatusEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level world = entity.level();
        if (!world.isClientSide && entity instanceof Player) {
            Player playerEntity = (Player)entity;
            playerEntity.getFoodData().eat(1, 0.25f);
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int i = 200 >> amplifier;
        if (i > 0) {
            return duration % i == 0;
        }
        return true;
    }
}

