/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.status_effects;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GravityStatusEffect
extends MobEffect {
    protected final float gravityPerLevel;

    public GravityStatusEffect(MobEffectCategory statusEffectCategory, int color, float gravityPerLevel) {
        super(statusEffectCategory, color);
        this.gravityPerLevel = gravityPerLevel;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        GravityStatusEffect.applyGravityEffect((Entity)entity, this.gravityPerLevel * (float)(amplifier + 1));
        return super.applyEffectTick(entity, amplifier);
    }

    public static void applyGravityEffect(Entity entity, double additionalYVelocity) {
        Player playerEntity;
        if (!(!entity.isPushable() || entity.isSpectator() || entity instanceof Player && (playerEntity = (Player)entity).isCreative())) {
            entity.push(0.0, additionalYVelocity, 0.0);
        }
    }
}

