/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.spells;

import com.google.common.collect.Maps;
import earth.terrarium.pastel.api.block.MoonstoneStrikeableBlock;
import earth.terrarium.pastel.networking.s2c_payloads.MoonstoneBlastPayload;
import earth.terrarium.pastel.particle.PastelParticleTypes;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MoonstoneStrike {
    private final Level world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final Entity entity;
    public final float power;
    public final float knockbackMod;
    private final DamageSource damageSource;
    protected final Map<Player, Vec3> affectedPlayers = Maps.newHashMap();

    public MoonstoneStrike(Level world, @Nullable Entity entity, @Nullable DamageSource damageSource, double x, double y, double z, float power, float knockbackMod) {
        this.world = world;
        this.entity = entity;
        this.power = power;
        this.knockbackMod = knockbackMod;
        this.x = x;
        this.y = y;
        this.z = z;
        this.damageSource = damageSource == null ? PastelDamageTypes.moonstoneStrike(world, this) : damageSource;
    }

    public static void create(Level world, Entity entity, @Nullable DamageSource damageSource, double x, double y, double z, float power, float pitch) {
        MoonstoneStrike.create(world, entity, damageSource, x, y, z, power, power, pitch);
    }

    public static void create(Level world, Entity entity, @Nullable DamageSource damageSource, double x, double y, double z, float power, float knockbackMod, float pitch) {
        MoonstoneStrike moonstoneStrike = new MoonstoneStrike(world, entity, damageSource, x, y, z, power, knockbackMod);
        if (world.isClientSide) {
            world.playLocalSound(x, y, z, PastelSounds.MOONSTONE_STRIKE, SoundSource.BLOCKS, 4.0f, pitch, false);
            world.playLocalSound(x, y, z, PastelSounds.SOFT_HUM, SoundSource.BLOCKS, 0.5f, pitch, false);
            world.addParticle((ParticleOptions)PastelParticleTypes.MOONSTONE_STRIKE, x, y, z, 1.0, 0.0, 0.0);
        } else {
            moonstoneStrike.damageAndKnockbackEntities();
            MoonstoneBlastPayload.sendMoonstoneBlast((ServerLevel)world, moonstoneStrike, pitch);
            moonstoneStrike.affectWorld();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPower() {
        return this.power;
    }

    public float getKnockbackMod() {
        return this.knockbackMod;
    }

    public DamageSource getDamageSource() {
        return this.damageSource;
    }

    public Map<Player, Vec3> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public void damageAndKnockbackEntities() {
        this.world.gameEvent(this.entity, (Holder)GameEvent.EXPLODE, new Vec3(this.x, this.y, this.z));
        float reach = this.power * 2.0f;
        int minX = Mth.floor((double)(this.x - (double)reach - 1.0));
        int maxX = Mth.floor((double)(this.x + (double)reach + 1.0));
        int minY = Mth.floor((double)(this.y - (double)reach - 1.0));
        int maxY = Mth.floor((double)(this.y + (double)reach + 1.0));
        int minZ = Mth.floor((double)(this.z - (double)reach - 1.0));
        int maxZ = Mth.floor((double)(this.z + (double)reach + 1.0));
        Vec3 center = new Vec3(this.x, this.y, this.z);
        for (Entity entity : this.world.getEntities(this.entity, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ))) {
            Player playerEntity;
            double dz;
            double dy;
            double dx;
            double dLen;
            double unitDist;
            if (entity.ignoreExplosion(null) || !((unitDist = Math.sqrt(entity.distanceToSqr(center)) / (double)reach) <= 1.0) || (dLen = Math.sqrt((dx = entity.getX() - this.x) * dx + (dy = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.y) * dy + (dz = entity.getZ() - this.z) * dz)) == 0.0) continue;
            dx /= dLen;
            dy /= dLen;
            dz /= dLen;
            double scaledExposure = (1.0 - unitDist) * (double)Explosion.getSeenPercent((Vec3)center, (Entity)entity);
            entity.hurt(this.damageSource, (float)((scaledExposure * scaledExposure + scaledExposure) / 2.0 * 7.0 * (double)reach + 1.0));
            double knockback = scaledExposure * (double)this.knockbackMod;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                knockback *= 1.0 - livingEntity.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE);
            }
            Vec3 impact = new Vec3(dx *= knockback, dy *= knockback, dz *= knockback);
            entity.setDeltaMovement(entity.getDeltaMovement().add(impact));
            if (!(!(entity instanceof Player) || (playerEntity = (Player)entity).isSpectator() || playerEntity.isCreative() && playerEntity.getAbilities().flying)) {
                this.affectedPlayers.put(playerEntity, impact);
            }
            entity.onExplosionHit(this.entity);
        }
    }

    public void affectWorld() {
        LivingEntity cause = this.getCausingEntity();
        int range = Math.max(2, (int)this.power / 2);
        for (BlockPos pos : BlockPos.withinManhattan((BlockPos)BlockPos.containing((double)this.x, (double)this.y, (double)this.z), (int)range, (int)range, (int)range)) {
            BlockState blockState = this.world.getBlockState(pos);
            Block block = blockState.getBlock();
            if (!(block instanceof MoonstoneStrikeableBlock)) continue;
            MoonstoneStrikeableBlock moonstoneStrikeableBlock = (MoonstoneStrikeableBlock)block;
            moonstoneStrikeableBlock.onMoonstoneStrike(this.world, pos, cause);
        }
    }

    @Nullable
    public LivingEntity getCausingEntity() {
        Projectile projectileEntity;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        entity = this.entity;
        if (entity instanceof Projectile && (entity = (projectileEntity = (Projectile)entity).getOwner()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        return null;
    }
}

