/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.items.tools.GlassCrestCrossbowItem;
import earth.terrarium.pastel.particle.effect.ColoredCraftingParticleEffect;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OverchargingSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final Player player;
    private final long lastParticleTick;
    private boolean done;

    public OverchargingSoundInstance(Player player) {
        super(PastelSounds.OVERCHARGING, SoundSource.PLAYERS, SoundInstance.createUnseededRandom());
        this.player = player;
        this.looping = false;
        this.delay = 0;
        this.volume = 0.4f;
        this.lastParticleTick = player.level().getGameTime() + 160L;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (!(this.player != null && this.player.isShiftKeyDown() && this.player.isUsingItem() && this.player.getItemInHand(this.player.getUsedItemHand()).getItem() instanceof GlassCrestCrossbowItem)) {
            this.setDone();
        } else {
            this.x = (float)this.player.getX();
            this.y = (float)this.player.getY();
            this.z = (float)this.player.getZ();
            if (this.player.level() != null && this.player.level().getGameTime() < this.lastParticleTick) {
                this.spawnParticles(this.player);
            } else {
                this.volume = 0.0f;
            }
        }
    }

    private void spawnParticles(Player player) {
        Level world = player.getCommandSenderWorld();
        RandomSource random = world.random;
        Vec3 pos = player.position();
        player.getCommandSenderWorld().addParticle((ParticleOptions)ColoredCraftingParticleEffect.WHITE, pos.x + random.nextDouble() * 0.8 - 0.4, pos.y, pos.z + random.nextDouble() * 0.8 - 0.4, 0.0, random.nextDouble() * 0.5, 0.0);
    }

    protected final void setDone() {
        this.done = true;
        this.looping = false;
    }
}

