/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.entity.entity.MagicProjectileEntity;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagicProjectileSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private final ResourceKey<Level> worldKey;
    private final MagicProjectileEntity projectile;
    private final int maxDurationTicks = 280;
    private int ticksPlayed = 0;
    private boolean done;
    private boolean playedExplosion;
    private float pitchMod;

    protected MagicProjectileSoundInstance(ResourceKey<Level> worldKey, MagicProjectileEntity projectile) {
        super(PastelSounds.INK_PROJECTILE_LAUNCH, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.worldKey = worldKey;
        this.projectile = projectile;
        this.attenuation = SoundInstance.Attenuation.NONE;
        this.x = this.projectile.getX();
        this.y = this.projectile.getY();
        this.z = this.projectile.getZ();
        this.looping = false;
        this.delay = 0;
        this.volume = 1.0f;
        this.pitchMod = Support.varFloatCentered(this.random, 0.1f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void startSoundInstance(MagicProjectileEntity projectile) {
        Minecraft client = Minecraft.getInstance();
        MagicProjectileSoundInstance newInstance = new MagicProjectileSoundInstance((ResourceKey<Level>)client.level.dimension(), projectile);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)newInstance);
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        Minecraft client = Minecraft.getInstance();
        ++this.ticksPlayed;
        this.x = this.projectile.getX();
        this.y = this.projectile.getY();
        this.z = this.projectile.getZ();
        float proximity = 1.0f - (float)this.projectile.position().distanceTo(client.cameraEntity.position()) / 48.0f;
        this.volume = Math.clamp(proximity, 0.0f, 1.0f);
        this.pitch = 1.0f - (1.0f - proximity) / 100.0f;
        this.pitch *= this.pitchMod;
        if (this.ticksPlayed > 280 || !Objects.equals(this.worldKey, Minecraft.getInstance().level.dimension()) || this.projectile.isRemoved()) {
            this.setDone();
        }
    }

    protected final void setDone() {
        this.ticksPlayed = this.maxDurationTicks;
        this.done = true;
        this.looping = false;
        if (this.projectile.isRemoved() && !this.playedExplosion) {
            this.projectile.spawnImpactParticles();
            this.playedExplosion = true;
        }
    }
}

