/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.sound;

import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DivinitySoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    private static int instances = 0;
    private int time = 0;
    private boolean done;

    public DivinitySoundInstance() {
        super(PastelSounds.MUSIC_DIVINITY, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.looping = true;
        this.delay = 0;
        this.volume = 0.8f;
        ++instances;
        Minecraft.getInstance().getSoundManager().stop(null, SoundSource.MUSIC);
    }

    public boolean isStopped() {
        return this.done;
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        Minecraft client = Minecraft.getInstance();
        ++this.time;
        this.volume = this.time > 1120 ? 0.8f : 0.5f + (float)this.time / 1120.0f * 0.2f;
        LocalPlayer player = client.player;
        if (instances > 1 || player == null || !player.hasEffect(PastelMobEffects.ASCENSION) && !player.hasEffect(PastelMobEffects.DIVINITY)) {
            this.setDone();
        } else {
            this.x = (float)player.getX();
            this.y = (float)player.getY();
            this.z = (float)player.getZ();
        }
    }

    protected final void setDone() {
        this.done = true;
        this.looping = false;
        --instances;
    }
}

