/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.compat.vanityslots.VanitySlotsCompat;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.client.PastelModelLayers;
import earth.terrarium.pastel.render.RenderingContext;
import earth.terrarium.pastel.render.armor.BedrockArmorCapeModel;
import earth.terrarium.pastel.render.armor.BedrockArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class BedrockCapeRenderer {
    private static <T extends Entity> void registerCapeLayer(EntityRenderer<T> baseRenderer) {
        if (!(baseRenderer instanceof LivingEntityRenderer)) {
            return;
        }
        LivingEntityRenderer livingRenderer = (LivingEntityRenderer)baseRenderer;
        if (!(livingRenderer.getModel() instanceof HumanoidModel)) {
            return;
        }
        LivingEntityRenderer humanoidRenderer = livingRenderer;
        humanoidRenderer.addLayer(new BedrockCapeLayer(humanoidRenderer));
    }

    public static void registerLayers(EntityRenderersEvent.AddLayers event) {
        EntityRenderer renderer;
        for (PlayerSkin.Model skin : event.getSkins()) {
            renderer = event.getSkin(skin);
            BedrockCapeRenderer.registerCapeLayer(renderer);
        }
        for (EntityType entityType : event.getEntityTypes()) {
            renderer = event.getRenderer(entityType);
            BedrockCapeRenderer.registerCapeLayer(renderer);
        }
    }

    private static class BedrockCapeLayer<T extends LivingEntity, M extends HumanoidModel<T>>
    extends RenderLayer<T, M> {
        public BedrockCapeLayer(RenderLayerParent<T, M> renderer) {
            super(renderer);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack chestStack = VanitySlotsCompat.getEquippedStack(livingEntity, EquipmentSlot.CHEST);
            if (chestStack.getItem() != PastelItems.BEDROCK_CHESTPLATE.get()) {
                return;
            }
            Tuple<Float, Float> capeRotations = BedrockArmorModel.computeFrontClothRotation(livingEntity, partialTick);
            float capeZOffset = ((Float)capeRotations.getB()).floatValue();
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)PastelModelLayers.BEDROCK_ARMOR_MAIN_ID));
            poseStack.pushPose();
            poseStack.translate(0.0, 0.5, 0.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(Mth.clamp((float)((Float)capeRotations.getA()).floatValue(), (float)-25.0f, (float)0.0f)));
            if (!livingEntity.isCrouching()) {
                poseStack.mulPose(Axis.ZP.rotationDegrees(capeZOffset / 2.0f));
            }
            poseStack.translate(0.0, -0.5, -0.025);
            if (livingEntity.isCrouching()) {
                poseStack.translate(0.0, 0.05, 0.35);
            }
            BedrockArmorCapeModel.FRONT_CLOTH.render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            if (RenderingContext.isElytraRendered) {
                return;
            }
            float backCapeRotation = Mth.clamp((float)(-((Float)capeRotations.getA()).floatValue()), (float)-30.0f, (float)45.0f);
            poseStack.pushPose();
            poseStack.translate(0.0, -0.05, 0.0);
            poseStack.mulPose(Axis.XP.rotationDegrees(backCapeRotation));
            poseStack.mulPose(Axis.ZP.rotationDegrees(capeZOffset / 2.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - capeZOffset / 3.5f));
            poseStack.translate(0.0, 0.05, -0.325);
            if (livingEntity.isCrouching()) {
                poseStack.translate(0.0, 0.15, 0.125);
            }
            BedrockArmorCapeModel.CAPE_MODEL.render(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

