/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.animation;

@FunctionalInterface
public interface KeyFrame<N extends Number> {
    public N at(float var1, long var2);

    public static <N extends Number> KeyFrame<N> simple(N number) {
        return (tickDelta, time) -> number;
    }

    public static KeyFrame<Float> sine(float frequency, float offset) {
        return KeyFrame.sine(frequency, 1.0f, offset);
    }

    public static KeyFrame<Float> sine(float frequency, float amplitude, float offset) {
        return KeyFrame.sine(frequency, amplitude, offset, 0.0f);
    }

    public static KeyFrame<Float> sine(float frequency, float amplitude, float offset, float delay) {
        return (tickDelta, time) -> Float.valueOf((float)(Math.sin(((float)time + tickDelta + delay) * frequency) * (double)amplitude + (double)offset));
    }
}

