/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.animation;

import java.util.function.Function;
import net.minecraft.util.Mth;

@FunctionalInterface
public interface Interpolation {
    public static final Interpolation LINEAR = (start, end, delta) -> Mth.lerp((double)delta, (double)start, (double)end);
    public static final Interpolation CLAMPED = Mth::clampedLerp;
    public static final Interpolation CUBIC_IN = Interpolation.normalize(delta -> Math.pow(delta.floatValue(), 3.0));
    public static final Interpolation CUBIC_OUT = Interpolation.normalize(delta -> 1.0 - Math.pow(1.0f - delta.floatValue(), 3.0));

    public double apply(double var1, double var3, float var5);

    public static Interpolation normalize(Function<Float, Number> rawDelta) {
        return (start, end, delta) -> Mth.lerp((double)((Number)rawDelta.apply(Float.valueOf(delta))).floatValue(), (double)start, (double)end);
    }
}

