/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.render.animation;

import earth.terrarium.pastel.render.animation.DataSignature;
import earth.terrarium.pastel.render.animation.FlowData;
import earth.terrarium.pastel.render.animation.FlowHandler;
import earth.terrarium.pastel.render.animation.Interpolation;

public class FlowHandlers {
    public static final FlowHandler<Integer> INT = new FlowHandler<Integer>(){

        @Override
        public FlowData<Integer> createData(DataSignature<Integer> signature) {
            return FlowData.create(signature);
        }

        @Override
        public Integer interpolate(Interpolation interpolation, Integer start, Integer end, float delta, long time) {
            return (int)Math.round(interpolation.apply(start.intValue(), end.intValue(), delta));
        }
    };
    public static final FlowHandler<Float> FLOAT = new FlowHandler<Float>(){

        @Override
        public FlowData<Float> createData(DataSignature<Float> signature) {
            return FlowData.create(signature);
        }

        @Override
        public Float interpolate(Interpolation interpolation, Float start, Float end, float delta, long time) {
            return Float.valueOf((float)interpolation.apply(start.floatValue(), end.floatValue(), delta));
        }
    };
}

