/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.google.common.base.Suppliers;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.function.Supplier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public enum PastelToolMaterial implements Tier
{
    LOW_HEALTH((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 16, 4.0f, 2.0f, 10, Ingredient::of),
    LOW_HEALTH_MINING_LEVEL_4((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 16, 4.0f, 2.0f, 10, Ingredient::of),
    VOIDING((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1143, 20.0f, 1.0f, 5, Ingredient::of),
    BEDROCK((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 0, 15.0f, 5.0f, 3, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.BEDROCK_DUST.get()})),
    DRACONIC((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 10000, 11.5f, 7.0f, 1, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.PURE_BLOODSTONE.get()})),
    MALACHITE((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 1536, 14.0f, 5.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.PURE_MALACHITE.get()})),
    GLASS_CREST((TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL, 6144, 18.0f, 10.0f, 5, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.PURE_MALACHITE.get()})),
    VERDIGRIS((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, 1536, 7.0f, 2.5f, 14, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.NIGHTDEW_SPROUT.get()})),
    NECTAR((TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL, PastelToolMaterial.GLASS_CREST.itemDurability, 9.5f, 9.0f, 30, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.AETHER_VESTIGES.get()})),
    DREAMFLAYER((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 650, 5.0f, 2.0f, 20, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.BISMUTH_CRYSTAL.get()})),
    NIGHTFALL((TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL, 650, 2.0f, 1.0f, 0, () -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelItems.MIDNIGHT_CHIP.get()}));

    private final TagKey<Block> inverseTag;
    private final int itemDurability;
    private final float miningSpeed;
    private final float attackDamage;
    private final int enchantability;
    private final Supplier<Ingredient> repairIngredient;

    private PastelToolMaterial(TagKey<Block> inverseTag, int itemDurability, float miningSpeed, float attackDamage, int enchantability, Supplier<Ingredient> repairIngredient) {
        this.inverseTag = inverseTag;
        this.itemDurability = itemDurability;
        this.miningSpeed = miningSpeed;
        this.attackDamage = attackDamage;
        this.enchantability = enchantability;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int getUses() {
        return this.itemDurability;
    }

    public float getSpeed() {
        return this.miningSpeed;
    }

    public float getAttackDamageBonus() {
        return this.attackDamage;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.inverseTag;
    }

    public int getEnchantmentValue() {
        return this.enchantability;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }
}

