/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.compat.PastelIntegrationPacks;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class PastelResourceConditions {
    public static final DeferredRegister<MapCodec<? extends ICondition>> REGISTER = DeferredRegister.create((Registry)NeoForgeRegistries.CONDITION_SERIALIZERS, (String)"pastel");

    public static void register(IEventBus modEventBus) {
        REGISTER.register("enchantments_exist", () -> EnchantmentsExistResourceCondition.CODEC);
        REGISTER.register("integration_pack_active", () -> IntegrationPackActiveResourceCondition.CODEC);
        REGISTER.register(modEventBus);
    }

    public record IntegrationPackActiveResourceCondition(String integrationPack) implements ICondition
    {
        public static MapCodec<IntegrationPackActiveResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("integration_pack").forGetter(IntegrationPackActiveResourceCondition::integrationPack)).apply((Applicative)instance, IntegrationPackActiveResourceCondition::new));

        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }

        public boolean test(ICondition.IContext iContext) {
            return PastelIntegrationPacks.isIntegrationPackActive(this.integrationPack);
        }
    }

    public record EnchantmentsExistResourceCondition(List<ResourceKey<Enchantment>> enchantments) implements ICondition
    {
        public static MapCodec<EnchantmentsExistResourceCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT).listOf().fieldOf("values").forGetter(EnchantmentsExistResourceCondition::enchantments)).apply((Applicative)instance, EnchantmentsExistResourceCondition::new));

        public MapCodec<? extends ICondition> codec() {
            return CODEC;
        }

        public boolean test(ICondition.IContext iContext) {
            return true;
        }
    }
}

