/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.interaction.ResonanceProcessor;
import earth.terrarium.pastel.api.predicate.block.BrokenBlockPredicate;
import earth.terrarium.pastel.data.DatagenProxy;
import earth.terrarium.pastel.data_loaders.resonance_processors.DropSelfResonanceProcessor;
import earth.terrarium.pastel.data_loaders.resonance_processors.ModifyDropsResonanceProcessor;
import earth.terrarium.pastel.registries.DeferredRegistrar;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRegistryKeys;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class PastelResonanceProcessors {
    private static final DeferredRegistrar.Contextual<DatagenProxy.BootstrapContext<ResonanceProcessor>> REGISTRAR = new DeferredRegistrar.Contextual(DatagenProxy.IS_DATAGEN);
    public static final ResourceKey<ResonanceProcessor> PURE_RESONANCES_FROM_ORE = PastelResonanceProcessors.register("pure_resonances_from_ore", ctx -> ModifyDropsResonanceProcessor.builder(BrokenBlockPredicate.Builder.create().registryEntryList((HolderSet<Block>)ctx.blocks().getOrThrow(Tags.Blocks.ORES)).build()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL}), (Item)PastelItems.PURE_COAL.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_COPPER}), (Item)PastelItems.PURE_COPPER.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND}), (Item)PastelItems.PURE_DIAMOND.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.ECHO_SHARD}), (Item)PastelItems.PURE_ECHO.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.EMERALD}), (Item)PastelItems.PURE_EMERALD.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), (Item)PastelItems.PURE_GLOWSTONE.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_GOLD}), (Item)PastelItems.PURE_GOLD.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.RAW_IRON}), (Item)PastelItems.PURE_IRON.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}), (Item)PastelItems.PURE_LAPIS.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_CRYSTALS}), (Item)PastelItems.PURE_PRISMARINE.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.QUARTZ}), (Item)PastelItems.PURE_QUARTZ.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}), (Item)PastelItems.PURE_REDSTONE.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.ANCIENT_DEBRIS}), (Item)PastelItems.PURE_NETHERITE_SCRAP.get()).addModifiedDrop(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_SCRAP}), (Item)PastelItems.PURE_NETHERITE_SCRAP.get()).build());
    public static final ResourceKey<ResonanceProcessor> BLACK_MATERIA = PastelResonanceProcessors.registerDropSelf("black_materia", (Block)PastelBlocks.BLACK_MATERIA.get(), builder -> builder);
    public static final ResourceKey<ResonanceProcessor> BRUSHABLE_BLOCKS = PastelResonanceProcessors.registerDropSelf("brushable_blocks", PastelBlockTags.C_BRUSHABLE_BLOCKS, builder -> builder.copyNbt("LootTable", "LootTableSeed", "item"));
    public static final ResourceKey<ResonanceProcessor> BUDDING_BLOCKS = PastelResonanceProcessors.registerDropSelf("budding_blocks", (TagKey<Block>)Tags.Blocks.BUDDING_BLOCKS, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> BUDS = PastelResonanceProcessors.registerDropSelf("buds", (TagKey<Block>)Tags.Blocks.BUDS, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> CAKE = PastelResonanceProcessors.registerDropSelf("cake", Blocks.CAKE, builder -> builder.copyState("bites"));
    public static final ResourceKey<ResonanceProcessor> CLUSTERS = PastelResonanceProcessors.registerDropSelf("clusters", (TagKey<Block>)Tags.Blocks.CLUSTERS, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> COMPOSTER = PastelResonanceProcessors.registerDropSelf("composter", Blocks.COMPOSTER, builder -> builder.copyState("level"));
    public static final ResourceKey<ResonanceProcessor> FROGSPAWN = PastelResonanceProcessors.registerDropSelf("frogspawn", Blocks.FROGSPAWN, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> GILDED_BLACKSTONE = PastelResonanceProcessors.registerDropSelf("gilded_blackstone", Blocks.GILDED_BLACKSTONE, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> INFESTED_BLOCKS = PastelResonanceProcessors.registerDropSelf("infested_blocks", PastelBlockTags.C_INFESTED_BLOCKS, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> REINFORCED_DEEPSLATE = PastelResonanceProcessors.registerDropSelf("reinforced_deepslate", Blocks.REINFORCED_DEEPSLATE, builder -> builder);
    public static final ResourceKey<ResonanceProcessor> RESPAWN_ANCHOR = PastelResonanceProcessors.registerDropSelf("respawn_anchor", Blocks.RESPAWN_ANCHOR, builder -> builder.copyState("charges"));
    public static final ResourceKey<ResonanceProcessor> SCULK_SHRIEKER = PastelResonanceProcessors.registerDropSelf("sculk_shrieker", Blocks.SCULK_SHRIEKER, builder -> builder.copyState("can_summon"));
    public static final ResourceKey<ResonanceProcessor> SIGNS = PastelResonanceProcessors.registerDropSelf("signs", (TagKey<Block>)BlockTags.ALL_SIGNS, builder -> builder.copyNbt("front_text", "back_text", "is_waxed"));
    public static final ResourceKey<ResonanceProcessor> SPAWNER = PastelResonanceProcessors.registerDropSelf("spawner", Blocks.SPAWNER, builder -> builder.copyNbt("SpawnData", "SpawnCount", "MinSpawnDelay", "MaxSpawnDelay", "SpawnRange", "RequiredPlayerRange", "SpawnPotentials", "MaxNearbyEntities"));

    public static ResourceKey<ResonanceProcessor> registerDropSelf(String id, Block block, UnaryOperator<DropSelfResonanceProcessor.Builder> builder) {
        return PastelResonanceProcessors.register(id, ctx -> ((DropSelfResonanceProcessor.Builder)builder.apply(DropSelfResonanceProcessor.builder(BrokenBlockPredicate.Builder.create().blocks(block).build()))).build());
    }

    public static ResourceKey<ResonanceProcessor> registerDropSelf(String id, TagKey<Block> tag, UnaryOperator<DropSelfResonanceProcessor.Builder> builder) {
        return PastelResonanceProcessors.register(id, ctx -> ((DropSelfResonanceProcessor.Builder)builder.apply(DropSelfResonanceProcessor.builder(BrokenBlockPredicate.Builder.create().registryEntryList((HolderSet<Block>)ctx.blocks().getOrThrow(tag)).build()))).build());
    }

    public static ResourceKey<ResonanceProcessor> register(String id, Function<DatagenProxy.BootstrapContext<ResonanceProcessor>, ResonanceProcessor> processor) {
        ResourceKey key = ResourceKey.create(PastelRegistryKeys.RESONANCE_PROCESSOR, (ResourceLocation)PastelCommon.locate(id));
        REGISTRAR.defer(ctx -> ctx.registerable().register(key, (Object)((ResonanceProcessor)processor.apply((DatagenProxy.BootstrapContext<ResonanceProcessor>)ctx))));
        return key;
    }

    public static void provideResonanceProcessors(DatagenProxy.BootstrapContext<ResonanceProcessor> ctx) {
        REGISTRAR.flush(ctx);
    }
}

