/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.api.pastel.PastelUpgradeSignature;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelRegistryKeys;
import java.util.function.Supplier;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class PastelPastelUpgrades {
    private static final DeferredRegister<PastelUpgradeSignature> REGISTER = DeferredRegister.create(PastelRegistryKeys.PASTEL_UPGRADE, (String)"pastel");
    private static final String NAMESPACE = "pastel";
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> WEAK_STACK;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> STRONG_STACK;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> WEAK_SPEED;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> STRONG_SPEED;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> WEAK_FILTER;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> STRONG_FILTER;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> RATE;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> LIGHT;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> ALWAYS_ON;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> ALWAYS_OFF;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> INVERTED;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> SENSOR;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> TRIGGER;
    public static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> LAMP;
    public static final PastelUpgradeSignature.Category NON_COMPOUNDING;
    public static final PastelUpgradeSignature.Category STACK;
    public static final PastelUpgradeSignature.Category SPEED;
    public static final PastelUpgradeSignature.Category FILTER;
    public static final PastelUpgradeSignature.Category REDSTONE;

    public static void register(IEventBus bus) {
        WEAK_STACK = PastelPastelUpgrades.register("weak_stack", () -> PastelUpgradeSignature.builder((Item)PastelItems.RAW_BLOODSTONE.get(), STACK, NAMESPACE).named("weak_stack").stackMod(3).stackMult(2.0f).build());
        STRONG_STACK = PastelPastelUpgrades.register("strong_stack", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_BLOODSTONE.get(), STACK, NAMESPACE).named("strong_stack").stackMod(15).stackMult(4.0f).build());
        WEAK_SPEED = PastelPastelUpgrades.register("weak_speed", () -> PastelUpgradeSignature.builder((Item)PastelItems.RAW_MALACHITE.get(), SPEED, NAMESPACE).named("weak_speed").speedMod(-5).speedMult(0.8f).build());
        STRONG_SPEED = PastelPastelUpgrades.register("strong_speed", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_MALACHITE.get(), SPEED, NAMESPACE).named("strong_speed").speedMod(-10).speedMult(0.5f).build());
        WEAK_FILTER = PastelPastelUpgrades.register("weak_filter", () -> PastelUpgradeSignature.builder((Item)PastelItems.RAW_AZURITE.get(), FILTER, NAMESPACE).named("weak_filter").slotRowMod(1).build());
        STRONG_FILTER = PastelPastelUpgrades.register("strong_filter", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_AZURITE.get(), FILTER, NAMESPACE).named("strong_filter").slotRowMod(2).build());
        RATE = PastelPastelUpgrades.register("rate", () -> PastelUpgradeSignature.builder((Item)PastelItems.RESONANCE_SHARD.get(), NON_COMPOUNDING, NAMESPACE).named("rate").priority(true).build());
        LIGHT = PastelPastelUpgrades.register("light", () -> PastelUpgradeSignature.builder((Item)PastelItems.SHIMMERSTONE_GEM.get(), NON_COMPOUNDING, NAMESPACE).named("light").light(true).build());
        ALWAYS_ON = PastelPastelUpgrades.register("always_active", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_REDSTONE.get(), REDSTONE, NAMESPACE).redstone("always_active").redstonePreProcess(context -> InteractionResult.SUCCESS).buildRedstone());
        ALWAYS_OFF = PastelPastelUpgrades.register("always_inactive", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_LAPIS.get(), REDSTONE, NAMESPACE).redstone("always_inactive").redstonePreProcess(context -> InteractionResult.FAIL).buildRedstone());
        INVERTED = PastelPastelUpgrades.register("inverted", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_COAL.get(), REDSTONE, NAMESPACE).redstone("inverted").redstonePostProcess(context -> {
            if (context.active()) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }).buildRedstone());
        LAMP = PastelPastelUpgrades.register("lamp", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_GLOWSTONE.get(), REDSTONE, NAMESPACE).redstone("lamp").lamp(true).buildRedstone());
        TRIGGER = PastelPastelUpgrades.register("trigger", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_QUARTZ.get(), REDSTONE, NAMESPACE).redstone("trigger").triggerTransfer(true).buildRedstone());
        SENSOR = PastelPastelUpgrades.register("sensor", () -> PastelUpgradeSignature.builder((Item)PastelItems.PURE_ECHO.get(), REDSTONE, NAMESPACE).redstone("sensor").sensor(true).buildRedstone());
        REGISTER.register(bus);
    }

    private static DeferredHolder<PastelUpgradeSignature, PastelUpgradeSignature> register(String name, Supplier<PastelUpgradeSignature> upgrade) {
        return REGISTER.register(name, upgrade);
    }

    public static PastelUpgradeSignature of(Item item) {
        return PastelRegistries.PASTEL_UPGRADE.stream().filter(upgrade -> upgrade.upgradeItem == item).findFirst().orElseThrow(() -> new IllegalArgumentException("Attempted to fetch an upgrade that does not exist"));
    }

    public static String toString(PastelUpgradeSignature upgrade) {
        return PastelRegistries.PASTEL_UPGRADE.getKey((Object)upgrade).toString();
    }

    public static PastelUpgradeSignature of(ItemStack stack) {
        return PastelPastelUpgrades.of(stack.getItem());
    }

    static {
        NON_COMPOUNDING = PastelUpgradeSignature.Category.nonCompounding();
        STACK = PastelUpgradeSignature.Category.simple();
        SPEED = PastelUpgradeSignature.Category.simple();
        FILTER = PastelUpgradeSignature.Category.simple();
        REDSTONE = PastelUpgradeSignature.Category.redstone();
    }
}

