/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.registries;

import earth.terrarium.pastel.api.interaction.ItemProvider;
import earth.terrarium.pastel.api.item.ItemStorage;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import org.jetbrains.annotations.Nullable;

public class PastelItemProviders {
    public static void register(IEventBus bus) {
        bus.addListener(event -> {
            event.registerItem(ItemProvider.CAPABILITY, (ignored, ignored2) -> PastelItemProviders.iterableProvider((player, stack) -> ((ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).nonEmptyItems()), new ItemLike[]{Items.SHULKER_BOX});
            event.registerItem(ItemProvider.CAPABILITY, (ignored, ignored2) -> PastelItemProviders.iterableProvider((player, stack) -> ((BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).items()), new ItemLike[]{Items.BUNDLE});
            event.registerItem(ItemProvider.CAPABILITY, (ignored, ignored2) -> new ItemProvider(){

                @Override
                public int provideItems(Player player, ItemStack stack, Item requestedItem, int amount) {
                    ItemStorage storage = ItemStorage.load(stack);
                    if (!storage.stack(1).is(requestedItem)) {
                        return 0;
                    }
                    return (int)storage.extractPure(amount);
                }

                @Override
                public int getItemCount(Player player, ItemStack stack, Item requestedItem) {
                    ItemStorage storage = ItemStorage.load(stack);
                    if (!storage.getReference().asItem().equals(requestedItem)) {
                        return 0;
                    }
                    return (int)Math.min(Integer.MAX_VALUE, storage.getCount());
                }
            }, new ItemLike[]{PastelBlocks.BOTTOMLESS_BUNDLE});
            event.registerItem(ItemProvider.CAPABILITY, (ignored, ignored2) -> PastelItemProviders.iterableProvider((player, stack) -> player == null ? List.of() : player.getEnderChestInventory().getItems()), new ItemLike[]{PastelItems.BAG_OF_HOLDING});
        });
    }

    public static ItemProvider iterableProvider(final BiFunction<@Nullable Player, ItemStack, Iterable<ItemStack>> iterableFactory) {
        return new ItemProvider(){

            @Override
            public int provideItems(Player player, ItemStack stack, Item requestedItem, int amount) {
                int removedCount = 0;
                for (ItemStack s : (Iterable)iterableFactory.apply(player, stack)) {
                    if (!s.is(requestedItem)) continue;
                    int amountToRemove = Math.min(s.getCount(), amount - removedCount);
                    s.shrink(amountToRemove);
                    if ((removedCount += amountToRemove) != amount) continue;
                    break;
                }
                return removedCount;
            }

            @Override
            public int getItemCount(Player player, ItemStack stack, Item requestedItem) {
                int count = 0;
                for (ItemStack s : (Iterable)iterableFactory.apply(player, stack)) {
                    if (!s.is(requestedItem)) continue;
                    count += s.getCount();
                }
                return count;
            }
        };
    }
}

