/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.titration_barrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.item.FermentedItem;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.helpers.interaction.TimeHelper;
import earth.terrarium.pastel.items.food.beverages.BeverageItem;
import earth.terrarium.pastel.recipe.FluidRecipeInput;
import earth.terrarium.pastel.recipe.GatedStackPastelRecipe;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationData;
import earth.terrarium.pastel.recipe.titration_barrel.FermentationStatusEffectEntry;
import earth.terrarium.pastel.recipe.titration_barrel.ITitrationBarrelRecipe;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class TitrationBarrelRecipe
extends GatedStackPastelRecipe<FluidRecipeInput<FluidTank>>
implements ITitrationBarrelRecipe {
    public static final List<Integer> FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS = new ArrayList<Integer>(){
        {
            this.add(1);
            this.add(10);
            this.add(100);
        }
    };
    public final List<IngredientStack> inputStacks;
    public final ItemStack outputItemStack;
    public final Item tappingItem;
    public final FluidIngredient fluid;
    public final int minFermentationTimeHours;
    public final FermentationData fermentationData;

    public TitrationBarrelRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, List<IngredientStack> inputStacks, FluidIngredient fluid, ItemStack outputItemStack, Item tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(group, secret, requiredAdvancementIdentifier);
        this.inputStacks = inputStacks;
        this.fluid = fluid;
        this.minFermentationTimeHours = minFermentationTimeHours;
        this.outputItemStack = outputItemStack;
        this.tappingItem = tappingItem;
        this.fermentationData = fermentationData;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(FluidRecipeInput<FluidTank> recipeInput, Level world) {
        FluidTank fluidStorage = recipeInput.getTank();
        if (!this.fluid.test(fluidStorage.getFluid())) {
            return false;
        }
        if (!this.fluid.isEmpty() && fluidStorage.getFluid().getAmount() != fluidStorage.getCapacity()) {
            return false;
        }
        return this.matchIngredientStacksExclusively(recipeInput, this.getIngredientStacks());
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.inputStacks;
    }

    @Override
    public Item getTappingItem() {
        return this.tappingItem;
    }

    @Override
    public int getMinFermentationTimeHours() {
        return this.minFermentationTimeHours;
    }

    @Override
    public FermentationData getFermentationData() {
        return this.fermentationData;
    }

    @Deprecated
    public ItemStack assemble(FluidRecipeInput<FluidTank> inventory, HolderLookup.Provider drm) {
        return this.getDefaultTap(1).copy();
    }

    public ItemStack getPreviewTap(int timeMultiplier) {
        return this.tapWith(1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    public ItemStack getDefaultTap(int timeMultiplier) {
        ItemStack stack = this.getPreviewTap(timeMultiplier);
        stack.setCount(this.outputItemStack.getCount());
        FermentedItem.setPreviewStack(stack);
        return stack;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.getDefaultTap(1);
    }

    public Collection<ItemStack> getOutputVariations(List<Integer> timeMultipliers) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int timeMultiplier : timeMultipliers) {
            list.add(this.getDefaultTap(timeMultiplier));
        }
        return list;
    }

    @Override
    public FluidIngredient getFluidInput() {
        return this.fluid;
    }

    @Override
    public float getAngelsSharePerMcDay() {
        return this.fermentationData.angelsSharePercentPerMcDay();
    }

    @Override
    public ItemStack tap(FriendlyStackHandler inventory, long secondsFermented, float downfall) {
        int contentCount = InventoryHelper.countItemsInInventory((IItemHandlerModifiable)inventory);
        float thickness = this.getThickness(contentCount);
        return this.tapWith(thickness, secondsFermented, downfall);
    }

    private ItemStack tapWith(float thickness, long secondsFermented, float downfall) {
        ItemStack stack = this.outputItemStack.copy();
        if (!(stack.getItem() instanceof FermentedItem)) {
            return stack;
        }
        return TitrationBarrelRecipe.getFermentedStack(this.fermentationData, thickness, secondsFermented, downfall, stack);
    }

    public static ItemStack getFermentedStack(@NotNull FermentationData fermentationData, float thickness, long secondsFermented, float downfall, ItemStack inputStack) {
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = 0.0;
        if (fermentationData.fermentationSpeedMod() > 0.0f) {
            alcPercent = TitrationBarrelRecipe.getAlcPercent(fermentationData.fermentationSpeedMod(), thickness, downfall, ageIngameDays);
            alcPercent = Math.max(0.0, alcPercent);
        }
        if (alcPercent >= 100.0 && inputStack.getItem() instanceof BeverageItem) {
            return ((Item)PastelItems.PURE_ALCOHOL.get()).getDefaultInstance();
        }
        PotionContents potionContents = (PotionContents)inputStack.get(DataComponents.POTION_CONTENTS);
        if (potionContents != null) {
            float durationMultiplier = (float)Support.logBase(1.0f + thickness, 2.0);
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            for (FermentationStatusEffectEntry entry : fermentationData.statusEffectEntries()) {
                int potency = -1;
                int durationTicks = entry.baseDuration();
                for (FermentationStatusEffectEntry.StatusEffectPotencyEntry potencyEntry : entry.potencyEntries()) {
                    if (!(thickness >= potencyEntry.minThickness()) || !(alcPercent >= (double)potencyEntry.minAlcPercent())) continue;
                    potency = potencyEntry.potency();
                }
                if (potency <= -1) continue;
                effects.add(new MobEffectInstance((Holder)BuiltInRegistries.MOB_EFFECT.getHolderOrThrow((ResourceKey)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)entry.statusEffect()).get()), (int)((float)durationTicks * durationMultiplier), potency));
            }
            inputStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), effects));
        }
        inputStack.set(PastelDataComponentTypes.BEVERAGE, (Object)new BeverageComponent((long)ageIngameDays, (int)alcPercent, thickness));
        return inputStack;
    }

    protected static double getAlcPercent(float fermentationSpeedMod, float thickness, float downfall, float ageIngameDays) {
        return Support.logBase(1.0f + fermentationSpeedMod, (double)ageIngameDays * (0.5 + (double)thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }

    protected float getThickness(int contentCount) {
        int inputStacksCount = 0;
        for (IngredientStack stack : this.inputStacks) {
            inputStacksCount += stack.getCount();
        }
        return (float)contentCount / (float)inputStacksCount;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.TITRATION_BARREL;
    }

    public static MutableComponent getDurationText(int minFermentationTimeHours, FermentationData fermentationData) {
        MutableComponent text = fermentationData.equals(FermentationData.DEFAULT) ? (minFermentationTimeHours == 1 ? Component.translatable((String)"container.pastel.rei.titration_barrel.time_hour") : (minFermentationTimeHours == 24 ? Component.translatable((String)"container.pastel.rei.titration_barrel.time_day") : (minFermentationTimeHours >= 72 ? Component.translatable((String)"container.pastel.rei.titration_barrel.time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : Component.translatable((String)"container.pastel.rei.titration_barrel.time_hours", (Object[])new Object[]{minFermentationTimeHours})))) : (minFermentationTimeHours == 1 ? Component.translatable((String)"container.pastel.rei.titration_barrel.at_least_time_hour") : (minFermentationTimeHours == 24 ? Component.translatable((String)"container.pastel.rei.titration_barrel.at_least_time_day") : (minFermentationTimeHours > 72 ? Component.translatable((String)"container.pastel.rei.titration_barrel.at_least_time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : Component.translatable((String)"container.pastel.rei.titration_barrel.at_least_time_hours", (Object[])new Object[]{minFermentationTimeHours}))));
        return text;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return ITitrationBarrelRecipe.UNLOCK_ADVANCEMENT_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "titration_barrel";
    }

    public static class Serializer
    implements RecipeSerializer<TitrationBarrelRecipe> {
        public static final MapCodec<TitrationBarrelRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)IngredientStack.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.inputStacks), (App)FluidIngredient.CODEC.optionalFieldOf("fluid", (Object)FluidIngredient.empty()).forGetter(recipe -> recipe.fluid), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.outputItemStack), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("tapping_item", (Object)Items.AIR).forGetter(recipe -> recipe.tappingItem), (App)Codec.INT.optionalFieldOf("min_fermentation_time_hours", (Object)24).forGetter(recipe -> recipe.minFermentationTimeHours), (App)FermentationData.CODEC.optionalFieldOf("fermentation", (Object)FermentationData.DEFAULT).forGetter(recipe -> recipe.fermentationData)).apply((Applicative)i, TitrationBarrelRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, TitrationBarrelRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, c -> c.group, ByteBufCodecs.BOOL, c -> c.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, IngredientStack.STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.inputStacks, FluidIngredient.STREAM_CODEC, c -> c.fluid, ItemStack.STREAM_CODEC, c -> c.outputItemStack, ByteBufCodecs.registry((ResourceKey)Registries.ITEM), recipe -> recipe.tappingItem, ByteBufCodecs.VAR_INT, recipe -> recipe.minFermentationTimeHours, FermentationData.STREAM_CODEC, recipe -> recipe.fermentationData, TitrationBarrelRecipe::new);

        public MapCodec<TitrationBarrelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TitrationBarrelRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

