/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SpawnerSpawnDelayChangeRecipe
extends SpawnerChangeRecipe {
    protected static final int DEFAULT_MIN_DELAY = 200;
    protected static final int DEFAULT_MAX_DELAY = 800;
    protected static final int MIN_MIN_DELAY = 20;
    protected static final int MIN_MAX_DELAY = 40;
    protected static final float EXPONENT = 0.98f;

    public SpawnerSpawnDelayChangeRecipe() {
        super(IngredientStack.ofItems((Item)PastelItems.MIDNIGHT_CHIP.get(), 4));
    }

    @Override
    public boolean canCraftWithBlockEntityTag(CustomData spawnerBlockEntityNbt, ItemStack leftBowlStack, ItemStack rightBowlStack) {
        if (spawnerBlockEntityNbt == null) {
            return true;
        }
        CompoundTag nbt = spawnerBlockEntityNbt.getUnsafe();
        return !(nbt.contains("MinSpawnDelay") && nbt.getShort("MinSpawnDelay") <= 20 || nbt.contains("MaxSpawnDelay") && nbt.getShort("MaxSpawnDelay") <= 40);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SPIRIT_INSTILLER_SPAWNER_SPAWN_DELAY_CHANGE;
    }

    @Override
    public Component getOutputLoreText() {
        return Component.translatable((String)"recipe.pastel.spawner.lore.decreased_spawn_delay");
    }

    @Override
    public CompoundTag getSpawnerResultNbt(CompoundTag spawnerBlockEntityNbt, ItemStack firstBowlStack, ItemStack secondBowlStack) {
        short newMaxSpawnDelay;
        short newMinSpawnDelay;
        short minSpawnDelay = 200;
        if (spawnerBlockEntityNbt.contains("MinSpawnDelay", 2)) {
            minSpawnDelay = spawnerBlockEntityNbt.getShort("MinSpawnDelay");
        }
        short maxSpawnDelay = 800;
        if (spawnerBlockEntityNbt.contains("MaxSpawnDelay", 2)) {
            maxSpawnDelay = spawnerBlockEntityNbt.getShort("MaxSpawnDelay");
        }
        if ((newMinSpawnDelay = (short)Math.pow(minSpawnDelay, 0.98f)) == minSpawnDelay) {
            newMinSpawnDelay = (short)(minSpawnDelay - 1);
        }
        if ((newMaxSpawnDelay = (short)Math.pow(maxSpawnDelay, 0.98f)) == maxSpawnDelay) {
            newMaxSpawnDelay = (short)(maxSpawnDelay - 1);
        }
        spawnerBlockEntityNbt.putShort("MinSpawnDelay", (short)Math.max(20, newMinSpawnDelay));
        spawnerBlockEntityNbt.putShort("MaxSpawnDelay", (short)Math.max(40, newMaxSpawnDelay));
        return spawnerBlockEntityNbt;
    }
}

