/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SpawnerRequiredPlayerRangeChangeRecipe
extends SpawnerChangeRecipe {
    protected static final int DEFAULT_DETECTION_RANGE = 16;
    protected static final int MAX_DETECTION_RANGE = 64;

    public SpawnerRequiredPlayerRangeChangeRecipe() {
        super(IngredientStack.ofItems((Item)PastelItems.STRATINE_GEM.get(), 4));
    }

    @Override
    public boolean canCraftWithBlockEntityTag(CustomData spawnerBlockEntityNbt, ItemStack leftBowlStack, ItemStack rightBowlStack) {
        if (spawnerBlockEntityNbt == null) {
            return true;
        }
        if (spawnerBlockEntityNbt.contains("RequiredPlayerRange")) {
            return spawnerBlockEntityNbt.copyTag().getShort("RequiredPlayerRange") < 64;
        }
        return true;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SPIRIT_INSTILLER_SPAWNER_SPAWNER_PLAYER_RANGE_CHANGE;
    }

    @Override
    public Component getOutputLoreText() {
        return Component.translatable((String)"recipe.pastel.spawner.lore.increased_required_player_range");
    }

    @Override
    public CompoundTag getSpawnerResultNbt(CompoundTag spawnerBlockEntityNbt, ItemStack firstBowlStack, ItemStack secondBowlStack) {
        short newRequiredPlayerRange;
        short requiredPlayerRange = 16;
        if (spawnerBlockEntityNbt.contains("RequiredPlayerRange", 2)) {
            requiredPlayerRange = spawnerBlockEntityNbt.getShort("RequiredPlayerRange");
        }
        if ((newRequiredPlayerRange = (short)Math.pow(requiredPlayerRange, 1.02)) == requiredPlayerRange) {
            newRequiredPlayerRange = (short)(requiredPlayerRange + 1);
        }
        spawnerBlockEntityNbt.putShort("RequiredPlayerRange", (short)Math.min(64, newRequiredPlayerRange));
        return spawnerBlockEntityNbt;
    }
}

