/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation;

import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.recipe.spirit_instiller.dynamic.spawner_manipulation.SpawnerChangeRecipe;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SpawnerMaxNearbyEntitiesChangeRecipe
extends SpawnerChangeRecipe {
    protected static final int DEFAULT_MAX_ENTITIES = 6;
    protected static final int MAX_MAX_ENTITIES = 40;

    public SpawnerMaxNearbyEntitiesChangeRecipe() {
        super(IngredientStack.ofItems((Item)PastelItems.MERMAIDS_GEM.get(), 4));
    }

    @Override
    public boolean canCraftWithBlockEntityTag(CustomData spawnerBlockEntityNbt, ItemStack leftBowlStack, ItemStack rightBowlStack) {
        if (spawnerBlockEntityNbt == null) {
            return true;
        }
        if (spawnerBlockEntityNbt.contains("MaxNearbyEntities")) {
            return spawnerBlockEntityNbt.copyTag().getShort("MaxNearbyEntities") < 40;
        }
        return true;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SPIRIT_INSTILLER_SPAWNER_MAX_NEARBY_ENTITIES_CHANGE;
    }

    @Override
    public Component getOutputLoreText() {
        return Component.translatable((String)"recipe.pastel.spawner.lore.increased_max_nearby_entities");
    }

    @Override
    public CompoundTag getSpawnerResultNbt(CompoundTag spawnerBlockEntityNbt, ItemStack firstBowlStack, ItemStack secondBowlStack) {
        int maxNearbyEntities = 6;
        if (spawnerBlockEntityNbt.contains("MaxNearbyEntities", 2)) {
            maxNearbyEntities = spawnerBlockEntityNbt.getShort("MaxNearbyEntities");
        }
        spawnerBlockEntityNbt.putShort("MaxNearbyEntities", (short)Math.min(40, maxNearbyEntities + 1));
        return spawnerBlockEntityNbt;
    }
}

