/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.potion_workshop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.recipe.DescriptiveGatedRecipe;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.recipe.potion_workshop.PotionMod;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class PotionWorkshopReactingRecipe
extends GatedPastelRecipe<RecipeInput>
implements DescriptiveGatedRecipe<RecipeInput> {
    protected static final HashMap<Item, List<PotionMod>> reagents = new HashMap();
    protected final Item item;
    protected final List<PotionMod> modifiers;

    public PotionWorkshopReactingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, Item item, List<PotionMod> modifiers) {
        super(group, secret, requiredAdvancementIdentifier);
        this.item = item;
        this.modifiers = modifiers;
        reagents.put(item, modifiers);
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(@NotNull RecipeInput inv, Level world) {
        return false;
    }

    public ItemStack assemble(RecipeInput inventory, HolderLookup.Provider registryManager) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.item.getDefaultInstance();
    }

    public ItemStack getToastSymbol() {
        return ((Block)PastelBlocks.POTION_WORKSHOP.get()).asItem().getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.POTION_WORKSHOP_REACTING_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.POTION_WORKSHOP_REACTING;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{this.item}));
        return defaultedList;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return PotionWorkshopRecipe.UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_reacting";
    }

    @Override
    public Component getDescription() {
        ResourceLocation identifier = BuiltInRegistries.ITEM.getKey((Object)this.item);
        return Component.translatable((String)("pastel.rei.potion_workshop_reacting." + identifier.getNamespace() + "." + identifier.getPath()));
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    public static boolean isReagent(Item item) {
        return reagents.containsKey(item);
    }

    public static PotionMod.Builder combine(PotionMod.Builder builder, ItemStack reagentStack, RandomSource random) {
        Item reagent = reagentStack.getItem();
        List reagentMods = reagents.getOrDefault(reagent, null);
        if (reagentMods != null) {
            builder.combine((PotionMod)reagentMods.get(random.nextInt(reagentMods.size())));
        }
        return builder;
    }

    public static class Serializer
    implements RecipeSerializer<PotionWorkshopReactingRecipe> {
        public static final MapCodec<PotionWorkshopReactingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(c -> c.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(c -> c.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(c -> c.requiredAdvancementIdentifier), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(c -> c.item), (App)CodecHelper.singleOrList(PotionMod.CODEC).fieldOf("modifiers").forGetter(c -> c.modifiers)).apply((Applicative)i, PotionWorkshopReactingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionWorkshopReactingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, c -> c.group, (StreamCodec)ByteBufCodecs.BOOL, c -> c.secret, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), c -> c.item, (StreamCodec)PotionMod.STREAM_CODEC.apply(ByteBufCodecs.list()), c -> c.modifiers, PotionWorkshopReactingRecipe::new);

        public MapCodec<PotionWorkshopReactingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionWorkshopReactingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

