/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.potion_workshop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.energy.InkPoweredStatusEffectInstance;
import earth.terrarium.pastel.api.item.InkPoweredPotionFillable;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.components.CustomPotionDataComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.potion_workshop.PotionMod;
import earth.terrarium.pastel.recipe.potion_workshop.PotionRecipeEffect;
import earth.terrarium.pastel.recipe.potion_workshop.PotionWorkshopRecipe;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelPotions;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionWorkshopBrewingRecipe
extends PotionWorkshopRecipe {
    public static final int BASE_POTION_COUNT_ON_BREWING = 3;
    public static final int ARROW_COUNT_MULTIPLIER = 8;
    protected static final List<Tuple<Float, Float>> SPLIT_EFFECT_POTENCY_AND_DURATION = new ArrayList<Tuple<Float, Float>>(){
        {
            this.add(new Tuple((Object)Float.valueOf(1.667f), (Object)Float.valueOf(0.1f)));
            this.add(new Tuple((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.334f)));
            this.add(new Tuple((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.667f)));
        }
    };
    public static final Map<Holder<MobEffect>, Holder<MobEffect>> negativeToPositiveEffect = new HashMap<Holder<MobEffect>, Holder<MobEffect>>(){
        {
            this.put(MobEffects.BAD_OMEN, MobEffects.HERO_OF_THE_VILLAGE);
            this.put(MobEffects.HUNGER, MobEffects.SATURATION);
            this.put(MobEffects.HARM, MobEffects.HEAL);
            this.put(MobEffects.DIG_SLOWDOWN, MobEffects.DIG_SPEED);
            this.put(MobEffects.MOVEMENT_SLOWDOWN, MobEffects.MOVEMENT_SPEED);
            this.put(MobEffects.UNLUCK, MobEffects.LUCK);
            this.put(MobEffects.WEAKNESS, MobEffects.DAMAGE_BOOST);
            this.put(MobEffects.WITHER, MobEffects.REGENERATION);
            this.put(PastelMobEffects.STIFFNESS, PastelMobEffects.SWIFTNESS);
            this.put(PastelMobEffects.DENSITY, PastelMobEffects.LIGHTWEIGHT);
        }
    };
    public static final List<PotionWorkshopBrewingRecipe> positiveRecipes = new ArrayList<PotionWorkshopBrewingRecipe>();
    public static final List<PotionWorkshopBrewingRecipe> negativeRecipes = new ArrayList<PotionWorkshopBrewingRecipe>();
    public final PotionRecipeEffect recipeData;
    protected ItemStack cachedOutput;

    @Nullable
    public static PotionWorkshopBrewingRecipe getPositiveRecipe(@NotNull Holder<MobEffect> statusEffect) {
        if (((MobEffect)statusEffect.value()).getCategory() == MobEffectCategory.HARMFUL) {
            Holder positiveEffect = negativeToPositiveEffect.getOrDefault(statusEffect, null);
            if (positiveEffect == null) {
                return null;
            }
            for (PotionWorkshopBrewingRecipe positiveRecipe : positiveRecipes) {
                if (positiveRecipe.recipeData.statusEffect() != positiveEffect) continue;
                return positiveRecipe;
            }
        }
        return null;
    }

    public PotionWorkshopBrewingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, int craftingTime, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3, PotionRecipeEffect recipeData) {
        super(group, secret, requiredAdvancementIdentifier, craftingTime, ((MobEffect)recipeData.statusEffect().value()).getColor(), ingredient1, ingredient2, ingredient3);
        this.recipeData = recipeData;
        this.registerInToastManager(this.getType(), this);
        if (((MobEffect)recipeData.statusEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL) {
            for (PotionWorkshopBrewingRecipe ae : positiveRecipes) {
                if (ae.recipeData.statusEffect().value() != recipeData.statusEffect()) continue;
                return;
            }
            positiveRecipes.add(this);
        } else if (((MobEffect)recipeData.statusEffect().value()).getCategory() == MobEffectCategory.HARMFUL) {
            for (PotionWorkshopBrewingRecipe ae : negativeRecipes) {
                if (ae.recipeData.statusEffect() != recipeData.statusEffect()) continue;
                return;
            }
            negativeRecipes.add(this);
        }
    }

    @Override
    public boolean isValidBaseIngredient(ItemStack itemStack) {
        InkPoweredPotionFillable fillable;
        Item item;
        return this.recipeData.applicableToPotions() && itemStack.is(Items.GLASS_BOTTLE) || this.recipeData.applicableToTippedArrows() && itemStack.is(Items.ARROW) || (item = itemStack.getItem()) instanceof InkPoweredPotionFillable && ((fillable = (InkPoweredPotionFillable)item).isWeapon() && this.recipeData.applicableToWeapons() || this.recipeData.applicableToPotionFillabes());
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.POTION_WORKSHOP_BREWING_RECIPE_SERIALIZER;
    }

    @Override
    public RecipeType<?> getType() {
        return PastelRecipeTypes.POTION_WORKSHOP_BREWING;
    }

    @Override
    public boolean usesReagents() {
        return true;
    }

    @Override
    public int getMinOutputCount(ItemStack baseItemStack) {
        return baseItemStack.is(Items.GLASS_BOTTLE) ? 3 : 1;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)IngredientStack.ofItems((Item)PastelItems.MERMAIDS_GEM.get()));
        defaultedList.add((Object)IngredientStack.ofItems(Items.GLASS_BOTTLE));
        this.addIngredientStacks((NonNullList<IngredientStack>)defaultedList);
        return defaultedList;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        if (this.cachedOutput == null) {
            this.cachedOutput = this.getPotion(Items.GLASS_BOTTLE.getDefaultInstance(), Items.POTION.getDefaultInstance(), new PotionMod.Builder().build(), null, RandomSource.create());
        }
        return this.cachedOutput;
    }

    public ItemStack assemble(RecipeInput inventory, HolderLookup.Provider drm) {
        ItemStack stack = new ItemStack((ItemLike)Items.POTION);
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Optional.empty(), Optional.empty(), List.of(new MobEffectInstance(this.recipeData.statusEffect(), this.recipeData.baseDurationTicks()))));
        return stack;
    }

    public float getModifiedYield(PotionMod potionMod) {
        return this.recipeData.baseYield() + potionMod.yield();
    }

    public List<ItemStack> getPotions(ItemStack stack, PotionMod potionMod, @Nullable RecipeHolder<PotionWorkshopBrewingRecipe> lastRecipe, RandomSource random, int brewedAmount) {
        ItemStack itemStack;
        PotionMod.Builder builder = new PotionMod.Builder(potionMod);
        if (potionMod.flags().makeSplashing()) {
            if (potionMod.flags().makeLingering()) {
                itemStack = new ItemStack((ItemLike)Items.LINGERING_POTION);
                if (potionMod.flags().negateDecreasingDuration()) {
                    builder.durationMultiplier(builder.durationMultiplier + 3.0f);
                }
            } else {
                itemStack = new ItemStack((ItemLike)Items.SPLASH_POTION);
            }
        } else {
            itemStack = new ItemStack((ItemLike)Items.POTION);
        }
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < brewedAmount; ++i) {
            results.add(this.getPotion(stack, itemStack.copy(), potionMod, lastRecipe, random));
        }
        return results;
    }

    public ItemStack getPotion(ItemStack originalStack, ItemStack targetStack, PotionMod potionMod, @Nullable RecipeHolder<PotionWorkshopBrewingRecipe> lastRecipe, RandomSource random) {
        List<InkPoweredStatusEffectInstance> effects = this.generateEffects(originalStack, potionMod, lastRecipe, random);
        if (effects.isEmpty()) {
            targetStack = PotionContents.createItemStack((Item)targetStack.getItem(), (Holder)Potions.THICK);
        } else {
            targetStack = PotionContents.createItemStack((Item)targetStack.getItem(), PastelPotions.PIGMENT_POTION);
            PotionWorkshopBrewingRecipe.setCustomPotionEffects(targetStack, potionMod, effects);
        }
        return targetStack;
    }

    public ItemStack getTippedArrows(ItemStack stack, PotionMod potionMod, @Nullable RecipeHolder<PotionWorkshopBrewingRecipe> lastRecipe, int amount, RandomSource random) {
        if (potionMod.flags().negateDecreasingDuration()) {
            potionMod = new PotionMod.Builder(potionMod).durationMultiplier(potionMod.durationMultiplier() + 7.0f).build();
        }
        List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
        ItemStack itemStack = new ItemStack((ItemLike)Items.TIPPED_ARROW, amount);
        if (effects.isEmpty()) {
            itemStack = PotionContents.createItemStack((Item)itemStack.getItem(), (Holder)Potions.THICK);
        } else {
            itemStack = PotionContents.createItemStack((Item)itemStack.getItem(), PastelPotions.PIGMENT_POTION);
            PotionWorkshopBrewingRecipe.setCustomPotionEffects(itemStack, potionMod, effects);
        }
        return itemStack;
    }

    public void fillPotionFillable(ItemStack stack, PotionMod potionMod, @Nullable RecipeHolder<PotionWorkshopBrewingRecipe> lastRecipe, RandomSource random) {
        Item item = stack.getItem();
        if (item instanceof InkPoweredPotionFillable) {
            InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)item;
            List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
            inkPoweredPotionFillable.addOrUpgradeEffects(stack, effects);
        }
    }

    private static void setCustomPotionEffects(ItemStack stack, PotionMod potionMod, List<InkPoweredStatusEffectInstance> effects) {
        ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
        for (InkPoweredStatusEffectInstance e : effects) {
            instances.add(e.getStatusEffectInstance());
        }
        OptionalInt potionColor = PotionContents.getColorOptional(instances);
        PotionContents potionComponent = new PotionContents(Optional.of(PastelPotions.PIGMENT_POTION), Optional.of(potionColor.orElse(0)), instances);
        stack.set(DataComponents.POTION_CONTENTS, (Object)potionComponent);
        if (potionMod.flags().unidentifiable() || potionMod.additionalDrinkDurationTicks() != 0) {
            stack.set(PastelDataComponentTypes.CUSTOM_POTION_DATA, (Object)new CustomPotionDataComponent(potionMod.flags().unidentifiable(), potionMod.additionalDrinkDurationTicks()));
        }
    }

    private List<InkPoweredStatusEffectInstance> generateEffects(ItemStack baseIngredient, PotionMod potionMod, @Nullable RecipeHolder<PotionWorkshopBrewingRecipe> lastRecipe, RandomSource random) {
        List<InkPoweredStatusEffectInstance> effects = new ArrayList<InkPoweredStatusEffectInstance>();
        this.addEffect(potionMod, random, effects);
        if (lastRecipe != null) {
            PotionWorkshopBrewingRecipe.addLastEffect(baseIngredient, potionMod, (PotionWorkshopBrewingRecipe)lastRecipe.value(), random, effects);
        }
        PotionWorkshopBrewingRecipe.addAdditionalEffects(baseIngredient, potionMod, random, effects);
        this.addRandomEffects(baseIngredient, potionMod, random, effects);
        if (potionMod.flags().potentDecreasingEffect()) {
            effects = this.applyPotentDecreasingEffect(effects, random);
        }
        return effects;
    }

    private static void addLastEffect(ItemStack baseIngredient, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, RandomSource random, List<InkPoweredStatusEffectInstance> effects) {
        if (lastRecipe != null && (potionMod.chanceToAddLastEffect() >= 1.0f || random.nextFloat() < potionMod.chanceToAddLastEffect()) && lastRecipe.recipeData.isApplicableTo(baseIngredient, potionMod)) {
            PotionMod lastEffectMod = new PotionMod.Builder(potionMod).potencyMultiplier(potionMod.lastEffectPotencyMultiplier()).durationMultiplier(potionMod.lastEffectDurationMultiplier()).build();
            lastRecipe.addEffect(lastEffectMod, random, effects);
        }
    }

    private static void addAdditionalEffects(ItemStack baseIngredient, PotionMod potionMod, RandomSource random, List<InkPoweredStatusEffectInstance> effects) {
        for (Tuple<PotionRecipeEffect, Float> entry : potionMod.flags().additionalEffects()) {
            InkPoweredStatusEffectInstance statusEffectInstance;
            if (!(random.nextFloat() < ((Float)entry.getB()).floatValue()) || !((PotionRecipeEffect)entry.getA()).isApplicableTo(baseIngredient, potionMod) || (statusEffectInstance = ((PotionRecipeEffect)entry.getA()).getStatusEffectInstance(potionMod, random)) == null) continue;
            effects.add(statusEffectInstance);
        }
    }

    private void addEffect(PotionMod potionMod, RandomSource random, List<InkPoweredStatusEffectInstance> effects) {
        PotionWorkshopBrewingRecipe positiveRecipe;
        if (potionMod.flags().makeEffectsPositive() && (positiveRecipe = PotionWorkshopBrewingRecipe.getPositiveRecipe(this.recipeData.statusEffect())) != null) {
            effects.add(positiveRecipe.recipeData.getStatusEffectInstance(potionMod, random));
            return;
        }
        InkPoweredStatusEffectInstance statusEffectInstance = this.recipeData.getStatusEffectInstance(potionMod, random);
        if (statusEffectInstance != null) {
            effects.add(statusEffectInstance);
        }
    }

    private void addRandomEffects(ItemStack baseIngredient, PotionMod potionMod, RandomSource random, List<InkPoweredStatusEffectInstance> effects) {
        int additionalNegativeEffectCount;
        int additionalPositiveEffectCount = Support.chanceRound(potionMod.additionalRandomPositiveEffectCount(), random);
        if (additionalPositiveEffectCount > 0) {
            List<PotionWorkshopBrewingRecipe> randomlySelectedRecipes = this.pullRandomMatchingRecipes(positiveRecipes, additionalPositiveEffectCount, effects, baseIngredient);
            for (PotionWorkshopBrewingRecipe recipe : randomlySelectedRecipes) {
                InkPoweredStatusEffectInstance statusEffectInstance = recipe.recipeData.getStatusEffectInstance(potionMod, random);
                if (statusEffectInstance == null) continue;
                effects.add(statusEffectInstance);
            }
        }
        if ((additionalNegativeEffectCount = Support.chanceRound(potionMod.additionalRandomNegativeEffectCount(), random)) > 0) {
            List<PotionWorkshopBrewingRecipe> randomlySelectedRecipes = this.pullRandomMatchingRecipes(potionMod.flags().makeEffectsPositive() ? positiveRecipes : negativeRecipes, additionalNegativeEffectCount, effects, baseIngredient);
            for (PotionWorkshopBrewingRecipe recipe : randomlySelectedRecipes) {
                InkPoweredStatusEffectInstance statusEffectInstance = recipe.recipeData.getStatusEffectInstance(potionMod, random);
                if (statusEffectInstance == null) continue;
                effects.add(statusEffectInstance);
            }
        }
    }

    private List<PotionWorkshopBrewingRecipe> pullRandomMatchingRecipes(List<PotionWorkshopBrewingRecipe> list, int amount, List<InkPoweredStatusEffectInstance> effects, ItemStack baseIngredient) {
        ArrayList<PotionWorkshopBrewingRecipe> results = new ArrayList<PotionWorkshopBrewingRecipe>();
        ArrayList<PotionWorkshopBrewingRecipe> shuffledPositiveRecipes = new ArrayList<PotionWorkshopBrewingRecipe>(list);
        Collections.shuffle(shuffledPositiveRecipes);
        int i = 0;
        for (PotionWorkshopBrewingRecipe recipe : shuffledPositiveRecipes) {
            if (i == amount) break;
            if (!recipe.isValidBaseIngredient(baseIngredient) || this.containsEffect(effects, (MobEffect)recipe.recipeData.statusEffect().value())) continue;
            results.add(recipe);
            ++i;
        }
        return results;
    }

    private boolean containsEffect(List<InkPoweredStatusEffectInstance> effects, MobEffect statusEffect) {
        for (InkPoweredStatusEffectInstance existingInstance : effects) {
            if (existingInstance.getStatusEffectInstance().getEffect() != statusEffect) continue;
            return true;
        }
        return false;
    }

    private List<InkPoweredStatusEffectInstance> applyPotentDecreasingEffect(@NotNull List<InkPoweredStatusEffectInstance> statusEffectInstances, RandomSource random) {
        ArrayList<InkPoweredStatusEffectInstance> splitInstances = new ArrayList<InkPoweredStatusEffectInstance>();
        for (InkPoweredStatusEffectInstance poweredInstance : statusEffectInstances) {
            MobEffectInstance instance = poweredInstance.getStatusEffectInstance();
            if (((MobEffect)instance.getEffect().value()).isInstantenous()) {
                splitInstances.add(poweredInstance);
                continue;
            }
            for (Tuple<Float, Float> mods : SPLIT_EFFECT_POTENCY_AND_DURATION) {
                int newDuration = (int)((float)instance.getDuration() * ((Float)mods.getB()).floatValue());
                int newAmplifier = Support.chanceRound((float)instance.getAmplifier() * ((Float)mods.getA()).floatValue(), random);
                if (newAmplifier < 0) continue;
                splitInstances.add(new InkPoweredStatusEffectInstance(new MobEffectInstance(instance.getEffect(), newDuration, newAmplifier, instance.isAmbient(), instance.isVisible()), poweredInstance.getInkCost(), poweredInstance.getColor(), poweredInstance.isUnidentifiable(), poweredInstance.isIncurable()));
            }
        }
        return splitInstances;
    }

    public MobEffect getStatusEffect() {
        return (MobEffect)this.recipeData.statusEffect().value();
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_brewing";
    }

    public static class Serializer
    implements RecipeSerializer<PotionWorkshopBrewingRecipe> {
        public static final MapCodec<PotionWorkshopBrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(c -> c.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(c -> c.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(c -> c.requiredAdvancementIdentifier), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(c -> c.craftingTime), (App)IngredientStack.CODEC.fieldOf("ingredient1").forGetter(c -> c.ingredient1), (App)IngredientStack.CODEC.optionalFieldOf("ingredient2", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient2), (App)IngredientStack.CODEC.optionalFieldOf("ingredient3", (Object)IngredientStack.EMPTY).forGetter(c -> c.ingredient3), (App)PotionRecipeEffect.CODEC.forGetter(c -> c.recipeData)).apply((Applicative)i, PotionWorkshopBrewingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionWorkshopBrewingRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, c -> c.group, ByteBufCodecs.BOOL, c -> c.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), c -> c.requiredAdvancementIdentifier, ByteBufCodecs.VAR_INT, c -> c.craftingTime, IngredientStack.STREAM_CODEC, c -> c.ingredient1, IngredientStack.STREAM_CODEC, c -> c.ingredient2, IngredientStack.STREAM_CODEC, c -> c.ingredient3, PotionRecipeEffect.STREAM_CODEC, c -> c.recipeData, PotionWorkshopBrewingRecipe::new);

        public MapCodec<PotionWorkshopBrewingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PotionWorkshopBrewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

