/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.pedestal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.api.item.GemstoneColor;
import earth.terrarium.pastel.api.recipe.IngredientStack;
import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.blocks.pedestal.PedestalRecipeInput;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRegistries;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ShapelessPedestalRecipe
extends PedestalRecipe {
    public ShapelessPedestalRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, PedestalTier tier, List<IngredientStack> craftingInputs, Map<GemstoneColor, Integer> gemstonePowderInputs, ItemStack output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(group, secret, requiredAdvancementIdentifier, tier, craftingInputs, gemstonePowderInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
    }

    @Override
    public boolean matches(PedestalRecipeInput recipeInput, Level world) {
        return this.matchIngredientStacksExclusively(recipeInput, this.getIngredientStacks(), recipeInput.getCraftingGridSlots()) && super.matches(recipeInput, world);
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.SHAPELESS_PEDESTAL_RECIPE_SERIALIZER;
    }

    @Override
    public void consumeIngredients(PedestalBlockEntity pedestal, PedestalRecipeInput input) {
        super.consumeIngredients(pedestal, input);
        FriendlyStackHandler inv = pedestal.getInventory();
        block0: for (int slot : CRAFTING_GRID_SLOTS) {
            for (IngredientStack ingredientStack : this.inputs) {
                ItemStack slotStack;
                if (!ingredientStack.test(slotStack = inv.getStackInSlot(slot))) continue;
                this.decrementGridSlot(pedestal, slot, ingredientStack.getCount(), slotStack);
                continue block0;
            }
        }
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessPedestalRecipe> {
        public static final MapCodec<ShapelessPedestalRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)PedestalTier.CODEC.optionalFieldOf("tier", (Object)PedestalTier.BASIC).forGetter(recipe -> recipe.tier), (App)IngredientStack.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.inputs), (App)CodecHelper.registryMap(PastelRegistries.GEMSTONE_COLOR, Codec.INT).fieldOf("colors").forGetter(recipe -> recipe.powderInputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience)), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("skip_recipe_remainders", (Object)false).forGetter(recipe -> recipe.skipRecipeRemainders), (App)Codec.BOOL.optionalFieldOf("disable_yield_upgrades", (Object)false).forGetter(recipe -> recipe.noBenefitsFromYieldUpgrades)).apply((Applicative)i, ShapelessPedestalRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ShapelessPedestalRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, PedestalTier.STREAM_CODEC, recipe -> recipe.tier, IngredientStack.STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.inputs, ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.registry((ResourceKey)PastelRegistries.GEMSTONE_COLOR.key()), (StreamCodec)ByteBufCodecs.VAR_INT), recipe -> recipe.powderInputs, ItemStack.STREAM_CODEC, recipe -> recipe.output, ByteBufCodecs.FLOAT, recipe -> Float.valueOf(recipe.experience), ByteBufCodecs.VAR_INT, recipe -> recipe.craftingTime, ByteBufCodecs.BOOL, recipe -> recipe.skipRecipeRemainders, ByteBufCodecs.BOOL, recipe -> recipe.noBenefitsFromYieldUpgrades, ShapelessPedestalRecipe::new);

        public MapCodec<ShapelessPedestalRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapelessPedestalRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

