/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.fluid_converting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class FluidConvertingRecipe
extends GatedPastelRecipe<RecipeInput> {
    protected final Ingredient input;
    protected final ItemStack output;

    public FluidConvertingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, @NotNull Ingredient input, ItemStack output) {
        super(group, secret, requiredAdvancementIdentifier);
        this.input = input;
        this.output = output;
    }

    public boolean matches(@NotNull RecipeInput inv, Level world) {
        return this.input.test(inv.getItem(0));
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider drm) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.input);
        return defaultedList;
    }

    public static class Serializer<T extends FluidConvertingRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.input), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)i, factory));
        private final StreamCodec<RegistryFriendlyByteBuf, T> packetCodec;

        public Serializer(Function5<String, Boolean, Optional<ResourceLocation>, Ingredient, ItemStack, T> factory) {
            this.packetCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, (StreamCodec)ByteBufCodecs.BOOL, recipe -> recipe.secret, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.input, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.output, factory);
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.packetCodec;
        }
    }
}

