/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.enchanter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.enchanter.EnchanterBlockEntity;
import earth.terrarium.pastel.blocks.upgrade.Upgradeable;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.capabilities.item.FriendlyStackHandler;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.enchanter.EnchanterRecipe;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchanterCraftingRecipe
extends EnchanterRecipe {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("midgame/build_enchanting_structure");
    protected final List<Ingredient> inputs;
    protected final ItemStack output;
    protected final int requiredExperience;
    protected final int craftingTime;
    protected final boolean noDiscounts;
    protected final boolean copyComponents;

    public EnchanterCraftingRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, List<Ingredient> inputs, ItemStack output, int craftingTime, int requiredExperience, boolean noDiscounts, boolean copyComponents) {
        super(group, secret, requiredAdvancementIdentifier);
        this.inputs = inputs;
        this.output = output;
        this.requiredExperience = requiredExperience;
        this.craftingTime = craftingTime;
        this.noDiscounts = noDiscounts;
        this.copyComponents = copyComponents;
        this.registerInToastManager(this.getType(), this);
    }

    public boolean matches(RecipeInput inv, Level level) {
        ItemStack center = inv.getItem(0);
        Integer availableXp = Optional.ofNullable((ExperienceHandler)inv.getItem(1).getCapability(PastelCapabilities.Misc.XP, (Object)level.registryAccess())).map(ExperienceHandler::getStoredAmount).orElse(0);
        if (!this.inputs.getFirst().test(center)) {
            return false;
        }
        if (this.requiredExperience > availableXp) {
            return false;
        }
        HashSet<Integer> matches = new HashSet<Integer>();
        block0: for (Ingredient ingredient : this.inputs.subList(1, 9)) {
            for (int slot = 1; slot < 9; ++slot) {
                if (matches.contains(slot) || !ingredient.test(inv.getItem(slot + 1))) continue;
                matches.add(slot);
                continue block0;
            }
        }
        return matches.size() == 8;
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider drm) {
        if (this.copyComponents) {
            return inv.getItem(0).transmuteCopy((ItemLike)this.output.getItem(), this.output.getCount());
        }
        return this.output.copy();
    }

    @Override
    public void consumeIngredients(EnchanterBlockEntity enchanter, HolderLookup.Provider lookup, double scaling) {
        HashSet<Integer> actioned = new HashSet<Integer>();
        FriendlyStackHandler inv = enchanter.getInputs();
        double output = 1.0;
        if (!this.noDiscounts) {
            output = 1.0f / enchanter.getUpgrades().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
        }
        block0: for (Ingredient ingredient : this.inputs.subList(1, 9)) {
            for (int slot = 1; slot < 9; ++slot) {
                if (actioned.contains(slot) || !ingredient.test(inv.getStackInSlot(slot + 1))) continue;
                assert (enchanter.getLevel() != null);
                inv.extractItem(slot + 1, Support.chanceRound(output, enchanter.getLevel().random), false);
                actioned.add(slot);
                continue block0;
            }
        }
        Optional.ofNullable((ExperienceHandler)inv.getStackInSlot(1).getCapability(PastelCapabilities.Misc.XP, (Object)lookup)).map(storage -> storage.extract(this.requiredExperience, false));
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryManager) {
        return this.output;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.ENCHANTER.get());
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.ENCHANTER_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.ENCHANTER;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)this.inputs.size());
        ingredients.addAll(this.inputs);
        return ingredients;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    @Override
    public int getCraftingTime(double unused) {
        return this.craftingTime;
    }

    @Override
    public boolean noDiscounts() {
        return this.noDiscounts;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "enchanter";
    }

    public static class Serializer
    implements RecipeSerializer<EnchanterCraftingRecipe> {
        public static final MapCodec<EnchanterCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Ingredient.CODEC_NONEMPTY.listOf().optionalFieldOf("ingredients", List.of()).forGetter(recipe -> recipe.inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.output), (App)Codec.INT.optionalFieldOf("required_experience", (Object)0).forGetter(recipe -> recipe.requiredExperience), (App)Codec.INT.optionalFieldOf("time", (Object)200).forGetter(recipe -> recipe.craftingTime), (App)Codec.BOOL.optionalFieldOf("disable_yield_and_efficiency_upgrades", (Object)false).forGetter(recipe -> recipe.noDiscounts), (App)Codec.BOOL.optionalFieldOf("copy_components", (Object)false).forGetter(recipe -> recipe.copyComponents)).apply((Applicative)i, EnchanterCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EnchanterCraftingRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.inputs, ItemStack.STREAM_CODEC, recipe -> recipe.output, ByteBufCodecs.VAR_INT, recipe -> recipe.requiredExperience, ByteBufCodecs.VAR_INT, recipe -> recipe.craftingTime, ByteBufCodecs.BOOL, recipe -> recipe.noDiscounts, ByteBufCodecs.BOOL, recipe -> recipe.copyComponents, EnchanterCraftingRecipe::new);

        public MapCodec<EnchanterCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EnchanterCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

