/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.crystallarieum;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.helpers.data.PacketCodecHelper;
import earth.terrarium.pastel.recipe.GatedPastelRecipe;
import earth.terrarium.pastel.recipe.crystallarieum.CrystallarieumCatalyst;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelFluids;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import org.jetbrains.annotations.Nullable;

public class CrystallarieumRecipe
extends GatedPastelRecipe<SingleRecipeInput> {
    public static final ResourceLocation UNLOCK_IDENTIFIER = PastelCommon.locate("unlocks/blocks/crystallarieum");
    protected static final Map<BlockState, RecipeHolder<CrystallarieumRecipe>> STATE_CACHE = new HashMap<BlockState, RecipeHolder<CrystallarieumRecipe>>();
    protected final Ingredient ingredient;
    protected final List<BlockState> growthStages;
    protected final int secondsPerGrowthStage;
    protected final InkColor inkColor;
    protected final int inkPerSecond;
    protected final boolean growsWithoutCatalyst;
    protected final List<CrystallarieumCatalyst> catalysts;
    protected final Optional<FluidIngredient> medium;
    protected final List<ItemStack> additionalResults;

    public CrystallarieumRecipe(String group, boolean secret, Optional<ResourceLocation> requiredAdvancementIdentifier, Ingredient ingredient, List<BlockState> growthStages, int secondsPerGrowthStage, InkColor inkColor, int inkPerSecond, boolean growsWithoutCatalyst, List<CrystallarieumCatalyst> catalysts, Optional<FluidIngredient> medium, List<ItemStack> additionalResults) {
        super(group, secret, requiredAdvancementIdentifier);
        this.ingredient = ingredient;
        this.growthStages = growthStages;
        this.secondsPerGrowthStage = secondsPerGrowthStage;
        this.inkColor = inkColor;
        this.inkPerSecond = inkPerSecond;
        this.growsWithoutCatalyst = growsWithoutCatalyst;
        this.catalysts = catalysts;
        this.medium = medium;
        this.additionalResults = additionalResults;
        this.registerInToastManager(this.getType(), this);
    }

    @Nullable
    public static RecipeHolder<CrystallarieumRecipe> getRecipeForState(Level world, BlockState state) {
        return STATE_CACHE.computeIfAbsent(state, s -> {
            List recipes = world.getRecipeManager().getAllRecipesFor(PastelRecipeTypes.CRYSTALLARIEUM);
            for (RecipeHolder recipe : recipes) {
                if (!((CrystallarieumRecipe)recipe.value()).growthStages.contains(s)) continue;
                return recipe;
            }
            return null;
        });
    }

    public boolean matches(SingleRecipeInput input, Level world) {
        return this.ingredient.test(input.getItem(0));
    }

    @Deprecated
    public ItemStack assemble(SingleRecipeInput inv, HolderLookup.Provider registryLookup) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryLookup) {
        List<BlockState> states = this.getGrowthStages();
        return states.getLast().getBlock().asItem().getDefaultInstance();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)PastelBlocks.CRYSTALLARIEUM.get());
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.CRYSTALLARIEUM_RECIPE_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return PastelRecipeTypes.CRYSTALLARIEUM;
    }

    @Override
    public ResourceLocation typeAdvancementID() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "crystallarieum_growing";
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList defaultedList = NonNullList.create();
        defaultedList.add((Object)this.ingredient);
        return defaultedList;
    }

    public FluidStack getFluidMedium() {
        return this.medium.map(f -> f.getStacks()[0]).orElseGet(CrystallarieumRecipe::getLiquidCrystal);
    }

    public Ingredient getIngredientStack() {
        return this.ingredient;
    }

    public CrystallarieumCatalyst getCatalyst(ItemStack itemStack) {
        for (CrystallarieumCatalyst catalyst : this.catalysts) {
            if (!catalyst.ingredient().test(itemStack)) continue;
            return catalyst;
        }
        return CrystallarieumCatalyst.EMPTY;
    }

    public List<BlockState> getGrowthStages() {
        return this.growthStages;
    }

    public int getSecondsPerGrowthStage() {
        return this.secondsPerGrowthStage;
    }

    public InkColor getInkColor() {
        return this.inkColor;
    }

    public int getInkPerSecond() {
        return this.inkPerSecond;
    }

    public boolean growsWithoutCatalyst() {
        return this.growsWithoutCatalyst;
    }

    public List<CrystallarieumCatalyst> getCatalysts() {
        return this.catalysts;
    }

    public List<ItemStack> getAdditionalResults() {
        return this.additionalResults;
    }

    public Optional<BlockState> getNextState(RecipeHolder<CrystallarieumRecipe> recipe, BlockState currentState) {
        Iterator<BlockState> it = ((CrystallarieumRecipe)recipe.value()).getGrowthStages().iterator();
        while (it.hasNext()) {
            BlockState state = it.next();
            if (!state.equals(currentState) || !it.hasNext()) continue;
            return Optional.of(it.next());
        }
        return Optional.empty();
    }

    private static FluidStack getLiquidCrystal() {
        return new FluidStack((Fluid)PastelFluids.LIQUID_CRYSTAL.get(), 1000);
    }

    public static class Serializer
    implements RecipeSerializer<CrystallarieumRecipe> {
        private static final MapCodec<CrystallarieumRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Codec.BOOL.optionalFieldOf("secret", (Object)false).forGetter(recipe -> recipe.secret), (App)ResourceLocation.CODEC.optionalFieldOf("required_advancement").forGetter(recipe -> recipe.requiredAdvancementIdentifier), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)BlockState.CODEC.listOf().fieldOf("growth_stage_states").forGetter(recipe -> recipe.growthStages), (App)Codec.INT.fieldOf("seconds_per_growth_stage").forGetter(recipe -> recipe.secondsPerGrowthStage), (App)InkColor.CODEC.fieldOf("ink_color").forGetter(recipe -> recipe.inkColor), (App)Codec.INT.xmap(d -> d == 0 ? 0 : 1 << d - 1, e -> e == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(e) + 1).fieldOf("ink_cost_tier").forGetter(recipe -> recipe.inkPerSecond), (App)Codec.BOOL.optionalFieldOf("grows_without_catalyst", (Object)false).forGetter(recipe -> recipe.growsWithoutCatalyst), (App)CrystallarieumCatalyst.CODEC.listOf().fieldOf("catalysts").forGetter(recipe -> recipe.catalysts), (App)FluidIngredient.CODEC.optionalFieldOf("fluid_medium").forGetter(recipe -> recipe.medium), (App)ItemStack.CODEC.listOf().optionalFieldOf("additional_recipe_manager_results", (Object)ImmutableList.of()).forGetter(recipe -> recipe.additionalResults)).apply((Applicative)i, CrystallarieumRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, CrystallarieumRecipe> STREAM_CODEC = PacketCodecHelper.tuple(ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, ByteBufCodecs.BOOL, recipe -> recipe.secret, ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), recipe -> recipe.requiredAdvancementIdentifier, Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.ingredient, PacketCodecHelper.BLOCK_STATE.apply(ByteBufCodecs.list()), recipe -> recipe.growthStages, ByteBufCodecs.VAR_INT, recipe -> recipe.secondsPerGrowthStage, InkColor.STREAM_CODEC, recipe -> recipe.inkColor, ByteBufCodecs.VAR_INT, recipe -> recipe.inkPerSecond, ByteBufCodecs.BOOL, recipe -> recipe.growsWithoutCatalyst, CrystallarieumCatalyst.STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.catalysts, ByteBufCodecs.optional((StreamCodec)FluidIngredient.STREAM_CODEC), recipe -> recipe.medium, ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()), recipe -> recipe.additionalResults, CrystallarieumRecipe::new);

        public MapCodec<CrystallarieumRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrystallarieumRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

