/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.crafting.dynamic;

import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.Level;

public abstract class SingleItemCraftingRecipe
extends CustomRecipe {
    public SingleItemCraftingRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput input, Level world) {
        boolean matchingItemFound = false;
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemStack itemStack = input.getItem(slot);
            if (itemStack.isEmpty()) continue;
            if (!matchingItemFound && this.matches(world, itemStack)) {
                matchingItemFound = true;
                continue;
            }
            return false;
        }
        return matchingItemFound;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registryLookup) {
        for (int slot = 0; slot < input.size(); ++slot) {
            ItemStack stack = input.getItem(slot);
            if (stack.isEmpty()) continue;
            return this.assemble(stack.copy());
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    public abstract boolean matches(Level var1, ItemStack var2);

    public abstract ItemStack assemble(ItemStack var1);
}

