/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe.crafting.dynamic;

import earth.terrarium.pastel.items.PigmentItem;
import earth.terrarium.pastel.items.magic_items.EverpromiseRibbonItem;
import earth.terrarium.pastel.registries.PastelRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class ColorEverpromiseRibbonRecipe
extends CustomRecipe {
    public ColorEverpromiseRibbonRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput input, Level world) {
        boolean ribbonFound = false;
        boolean pigmentFound = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemStack = input.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof EverpromiseRibbonItem) {
                if (!itemStack.has(DataComponents.CUSTOM_NAME)) {
                    return false;
                }
                if (ribbonFound) {
                    return false;
                }
                ribbonFound = true;
                continue;
            }
            if (itemStack.getItem() instanceof PigmentItem) {
                if (pigmentFound) {
                    return false;
                }
                pigmentFound = true;
                continue;
            }
            return false;
        }
        return ribbonFound && pigmentFound;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registryLookup) {
        ItemStack ribbon = null;
        PigmentItem pigment = null;
        for (int i = 0; i < input.size(); ++i) {
            PigmentItem pigmentItem;
            Item item;
            ItemStack stack = input.getItem(i);
            if (stack.getItem() instanceof EverpromiseRibbonItem) {
                ribbon = stack;
            }
            if (!((item = stack.getItem()) instanceof PigmentItem)) continue;
            pigment = pigmentItem = (PigmentItem)item;
        }
        if (ribbon == null || pigment == null) {
            return ItemStack.EMPTY;
        }
        ribbon = ribbon.copy();
        ribbon.setCount(1);
        Component text = ribbon.getHoverName();
        if (text instanceof MutableComponent) {
            MutableComponent mutableText = (MutableComponent)text;
            TextColor newColor = TextColor.fromRgb((int)pigment.getInkColor().getColorInt());
            MutableComponent newName = mutableText.setStyle(mutableText.getStyle().withColor(newColor));
            ribbon.set(DataComponents.CUSTOM_NAME, (Object)newName);
        }
        return ribbon;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return PastelRecipeSerializers.COLOR_EVERPROMISE_RIBBON_SERIALIZER;
    }
}

