/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelRegistryKeys;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public abstract class RecipeScaling {
    public static final Codec<ScalingData> CODEC = RecordCodecBuilder.create(i -> i.group((App)PastelRegistries.RECIPE_SCALING.byNameCodec().fieldOf("type").forGetter(d -> d.type), (App)Codec.INT.optionalFieldOf("start", (Object)0).forGetter(d -> d.start), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("scaling_value", (Object)0).forGetter(d -> d.scalingValue), (App)Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("scaling_factor", (Object)1.0).forGetter(d -> d.scalingFactor), (App)Codec.INT.listOf(0, 255).optionalFieldOf("indexes", Collections.emptyList()).forGetter(d -> d.indexes)).apply((Applicative)i, ScalingData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScalingData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry(PastelRegistryKeys.RECIPE_SCALING), d -> d.type, (StreamCodec)ByteBufCodecs.VAR_INT, d -> d.start, (StreamCodec)ByteBufCodecs.VAR_INT, d -> d.scalingValue, (StreamCodec)ByteBufCodecs.DOUBLE, d -> d.scalingFactor, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), d -> d.indexes, ScalingData::new);
    public static final RecipeScaling LINEAR = new RecipeScaling(PastelCommon.locate("linear")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            return data.start + (int)Math.round((double)data.scalingValue * scaling * data.scalingFactor);
        }
    };
    public static final RecipeScaling DOUBLING = new RecipeScaling(PastelCommon.locate("doubling")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            return data.start + data.scalingValue << (int)Math.round((scaling - 1.0) * data.scalingFactor);
        }
    };
    public static final RecipeScaling EXPONENTIAL = new RecipeScaling(PastelCommon.locate("exponential")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            return (int)((long)data.start + Math.round(Math.pow(data.scalingValue, scaling * data.scalingFactor)));
        }
    };
    public static final RecipeScaling INDEXED = new RecipeScaling(PastelCommon.locate("indexed")){

        @Override
        int getInputCount(double scaling, ScalingData data) {
            int size = data.indexes.size();
            return data.indexes.get(Math.clamp((long)((int)Math.round(scaling - 1.0)), 0, size - 1));
        }
    };
    private final ResourceLocation id;

    public RecipeScaling(ResourceLocation id) {
        this.id = id;
    }

    abstract int getInputCount(double var1, ScalingData var3);

    public ResourceLocation getId() {
        return this.id;
    }

    public static ScalingData linear(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(LINEAR, start, scalingValue, scalingFactor, List.of(indices));
    }

    public static ScalingData doubling(int scalingValue, Integer ... indices) {
        return new ScalingData(DOUBLING, 0, scalingValue, 1.0, List.of(indices));
    }

    public static ScalingData doubling(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(DOUBLING, start, scalingValue, scalingFactor, List.of(indices));
    }

    public static ScalingData exponential(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(EXPONENTIAL, start, scalingValue, scalingFactor, List.of(indices));
    }

    public static ScalingData indices(Integer ... indices) {
        return RecipeScaling.indexed(0, 0, 1.0, indices);
    }

    public static ScalingData indexed(int start, int scalingValue, double scalingFactor, Integer ... indices) {
        return new ScalingData(INDEXED, start, scalingValue, scalingFactor, List.of(indices));
    }

    public record ScalingData(RecipeScaling type, int start, int scalingValue, double scalingFactor, List<Integer> indexes) {
        public int apply(double scaling) {
            return this.type.getInputCount(scaling, this);
        }
    }
}

